# Social Determinants of Health and Diabetes: A Scientific Review

Diabetes Care 2021;44:258–279 | https://doi.org/10.2337/dci20-0053

Decades of research have demonstrated that diabetes affects racial and ethnic minority and low-income adult populations in the U.S. disproportionately, with relatively intractable patterns seen in these populations’ higher risk of diabetes and rates of diabetes complications and mortality (1). With a health care shift toward greater emphasis on population health outcomes and value-based care, social determinants of health (SDOH) have risen to the forefront as essential intervention targets to achieve health equity (2–4). Most recently, the COVID-19 pandemic has highlighted unequal vulnerabilities borne by racial and ethnic minority groups and by disadvantaged communities. In the wake of concurrent pandemic and racial injustice events in the U.S., the American College of Physicians, American Academy of Pediatrics, Society of General Internal Medicine, National Academy of Medicine, and other professional organizations have published statements on SDOH (5–8), and calls to action focus on amelioration of these determinants at individual, organizational, and policy levels (9–11).

In diabetes, understanding and mitigating the impact of SDOH are priorities due to disease prevalence, economic costs, and disproportionate population burden (12–14). In 2013, the American Diabetes Association (ADA) published a scientific statement on socioecological determinants of prediabetes and type 2 diabetes (15). Toward the goal of understanding and advancing opportunities for health improvement among the population with diabetes through addressing SDOH, ADA convened the current SDOH and diabetes writing committee, prepandemic, to review the literature on 1) associations of SDOH with diabetes risk and outcomes and 2) impact of interventions targeting amelioration of SDOH on diabetes outcomes. This article begins with an overview of key definitions and SDOH frameworks. The literature review focuses primarily on U.S.-based studies of adults with diabetes and on five SDOH: socioeconomic status (education, income, occupation); neighborhood and physical environment (housing, built environment, toxic environmental exposures); food environment (food insecurity, food access); health care (access, affordability, quality); and social context (social cohesion, social capital, social support). This review concludes with recommendations for linkages across health care and community sectors from national advisory committees, recommendations for diabetes research, and recommendations for research to inform practice.

# DEFINITIONS OF HEALTH DISPARITIES, HEALTH EQUITY, AND SDOH

Table 1 displays definitions of key terms. Differences in diabetes risk and outcomes can result from multiple contributors, including biological, clinical, and nonclinical factors (1). A substantial body of scientific literature demonstrates the adverse impact of a particular type of difference, health disparities (16) in diabetes (1,17,18). A preponderance of health disparities research in the U.S. has examined disparities by race and ethnicity (3,19). Internationally, the term health equity has traditionally been used to encompass the range of population inequalities resulting from demographic and economic characteristics, and this term is used increasingly in the U.S. (20–24). Addressing healthy equity necessitates an understanding of social and environmental factors that combined account for $50 \%$ to $60 \%$ of health outcomes (22,25). These social and environmental factors collectively are known as SDOH (21,26,27).

# SDOH NOMENCLATURES AND CONTEXTUAL FACTORS

The writing committee reviewed the following commonly referenced SDOH frameworks for classifications and terminology: the World Health Organization (WHO) Commission on Social Determinants of Health (28), Healthy People 2020 (29,30), the

# 11, and 188.

<html><body><table><tr><td colspan="2">Table 1-Definitions Term</td></tr><tr><td> Health disparities</td><td>Definition A particular type of health difference that is closely linked with social,economic,and/or environmental disadvantage. Health disparities adversely affect groups of people who have systematically experienced greater obstacles to health based on their racial orethnic group; religion; socioeconomic status;sex;age; mental health; cognitive,sensory,or physical disability;sexual orientationorgender identity;geographiclocation;orothercharacteristics historicallylinked todiscrimination or exclusion</td></tr><tr><td> Health equity</td><td>(16). Equityis the absence ofavoidable,unfair,or remediable diferences among groups of people, whether those groups are defined socially，,economically， demographically,or geographically or by other means of stratification.“Health equity&quot; or &quot;equity in health&quot; implies that ideally everyone should have a fair opportunity to attain their fullhealth potential and that no one should be disadvantaged from achieving this potential (24). Health equity is attainment of the highest level of health forallpeople.Achieving health equity requires valuing everyone equally with focused and ongoing societal efforts to address avoidable inequalities,</td></tr><tr><td>Social determinants of health (SDOH)</td><td>historicaland contemporaryinjustices,and the elimination of health and health care disparities (23). The socialdeterminants of healthare the conditions inwhich peopleare born,grow,live,work,andage. These circumstances are shaped by the distribution of money, power, and resources at global, national,and local levels.The social determinants of health are mostly responsible for health inequities—the unfair and avoidable differences in health status seen within and between countries (26).</td></tr></table></body></html>

County Health Rankings Model (31,32), and Kaiser Family Foundation Social Determinants of Health factors (33).

No single consensus set of factors define SDOH. Nomenclatures used by each framework, for shared SDOH factors, are depicted in Fig. 1. Common among the frameworks is placement of economic and socioeconomic determinants as foremost. Food SDOH factors (e.g., insecurity and access) are classified as economic stability (29), neighborhood and built environment (29), material circumstances (28), or as an independent category (33). Housing is classified as material circumstances (28), economic stability (29), or neighborhood and built environment (33). Environmental exposures (i.e., toxins, air pollution, and water quality) are classified as neighborhood and physical environment (31) or built environment (29). Social environment is represented as community and societal context (29,33), social cohesion and social capital (28), or social factors (31). Health care is a SDOH in the WHO, Healthy People 2020, and County Health Rankings models, with access factors as primary, with or without quality of care factors.

Each framework posits complex interactions among SDOH factors. WHO additionally maps causal priority among the determinants. For example, the upstream sociopolitical context and resulting socioeconomic position are root cause, structural determinants of health inequities that work through intermediary sets of determinants to cause health inequities. WHO positions the health system as an SDOH that plays a role in mediating impact of intermediary determinants on health outcomes (28).

# REVIEW OF SDOH AND DIABETES

SDOH inclusion in this review was determined by representation within one or more existing SDOH frameworks and presence of a sufficient body of literature to demonstrate influence of the determinant on diabetes. The reviewed SDOH are shown in Table 2. Studies of primarily adult populations are described, and the terms type 2 diabetes mellitus (T2DM), type 1 diabetes mellitus (T1DM), and “diabetes” (indicating either a mixed T2DM and T1DM sample or diabetes case ascertainment methods that do not enable specifying clinical diagnostic type) are used in accordance with the terminology used in the respective studies.

# Socioeconomic Status and Diabetes

Socioeconomic status (SES) is a multidimensional construct that includes educational, economic, and occupational status (34–36). SES is a consistently strong predictor of disease onset and progression at all levels of SES for many diseases, including diabetes (37). SES is linked to virtually all of the established SDOH. It is associated with the extent to which individuals and communities can access material resources including health care, housing, transportation, and nutritious food and social resources such as political power, social engagement, and control.

The three components of SES are intercorrelated (38), but each aspect has unique implications for health. Each component can be assessed at the individual or population level (39). For example, economic status is often measured by determining a person’s own income. However, it is also assessed by the income of the household in which the person resides and by the income level of the community (e.g., mean household income of the census track in which a person resides) as a proxy for the individual’s household income. Census-level household income also operates as a contextual variable, reflecting the composition and available resources in a defined area.

Educational status can be quantified either in years of schooling or highest degree earned. It may be assessed at the level of the individual (e.g., the person’s own educational attainment), the household (the highest grade completed by anyone in the household), or the community (e.g., percent of high school or college graduates in a census track). Quantity of education does not capture differences in quality of education that may be relevant to SES measurement (38). Literacy has emerged as a measure of educational quality and as potentially more reflective of SES than years of schooling among African Americans and low-income Whites (40,41). Health literacy, which is directly associated with literacy and is context specific (42–44), and literacy are included as SDOH in Healthy People 2020 (29).

![](images/6fed602dbdbcc0705814f4dabe3e4ae8d15d31cd433a1e6b986c79079609baed.jpg)  
Figure 1—Nomenclatures for shared determinants among four social determinants of health frameworks, the World Health Organization Commission on the Social Determinants of Health, the U.S. Department of Health and Human Services Healthy People 2020, the County Health Rankings Model, and the Kaiser Family Foundation Social Determinants of Health framework.

Occupation is itself multidimensional. It has been measured as employment status (e.g., employed vs. unemployed), stability (e.g., job insecurity), job type (e.g., manual vs. nonmanual, prestige of the occupation), and working conditions (e.g., shift work, number of hours worked, job demands, and control) (39,45). For members of large organizations, occupational hierarchies of job titles capture work conditions as well as qualifications and pay (e.g., civil service grades).

# Associations of SES With Diabetes Incidence, Prevalence, and Outcomes

Income, education, and occupation show a graded association with diabetes prevalence and complications across all levels of SES, up to the very top. Those lower on the SES ladder are more likely to develop T2DM, experience more complications, and die sooner than those higher up on the SES ladder (46,47). The higher a person’s income, the greater their educational attainment, and the higher their occupational grade, the less likely they are to develop T2DM or to experience its complications. The gradient is steeper at the bottom, however, and research has focusedprimarilyonthosewiththelowest levels of income and education.

Income. Prevalence of diabetes increases on a gradient from highest to lowest income (48,49). In data from the National Health Interview Survey (NHIS) covering 2011–2014, Beckles and Chou (50) found increasing diabetes prevalence at lower levels of income as reflected in the levels of ratio of income to poverty level. Compared with those with high income, the relative percentage difference in prevalence of diabetes for those classified as middle income, near poor, and poor, was $4 0 . 0 \% ,$ , $7 4 . 1 \%$ , and $1 0 0 . 4 \%$ , respectively. The difference in diabetes prevalence by income was greater during this time period than it had been in a prior period (1999–2002), pointing to widening disparities in diabetes prevalence associated with income.

At the neighborhood level, differences in diabetes prevalence by census track are attributable to SES (51,52). For example, in a recent study by Kolak et al. (52), rate of T2DM was found to be significantly higher and concentrated in census tracts characterized by factors including lower incomes, lower high school graduation rates,moresingle-parenthouseholds, and crowded housing. Living in neighborhood census tracts with lower educational attainment, lower annual income, and larger percentage of households receiving Supplemental Nutrition Assistance Program benefits has been associated with higher risk of progression to T2DM among adults with prediabetes (53).

Table 2—SDOH and component factors included in the diabetes review   

<html><body><table><tr><td>Socioeconomicstatus</td><td>Neighborhood and physical environment</td><td>Food environment</td><td>Health care</td><td>Social context</td></tr><tr><td> Education</td><td>Housing</td><td>Food security</td><td>Access</td><td>Social cohesion</td></tr><tr><td>Income</td><td>Built environment</td><td>Food access</td><td> Affordability</td><td>Social capital</td></tr><tr><td>Occupation</td><td>Toxic environmental exposures</td><td>Food availability</td><td>Quality</td><td>Social support</td></tr></table></body></html>

Gaskin et al. (49) examined the interaction of individual poverty with neighborhood poverty and found that, compared with nonpoor adults living in nonpoor neighborhoods, poor adults living in nonpoor neighborhoods have increased odds of having diabetes, and poor adults living in poor neighborhoods have twofold higher odds of having diabetes. In addition, a race-poverty-place gradient was observed. Compared with nonpoor Whites in nonpoor neighborhoods, odds of diabetes were highest for poor Whites in poor neighborhoods (odds ratio [OR] 2.51, $9 5 \% \mathsf { C l } = 1 . 3 1 – 4 . 8 1$ ), followed by poor Blacks in poor neighborhoods and nonpoor Blacks in poor neighborhoods (OR 2.45, $9 5 \% \mathsf { C l } 1 . 5 0 { - 4 . 0 1 }$ , and OR 2.49, $9 5 \% { \mathsf { C l } } 1 1 . 4 8 { - 4 . 1 9 }$ ), and finally poor Whites in nonpoor neighborhoods (OR 1.73, $9 5 \%$ CI 1.16–2.57) (49).

Adults with T2DM who have a family income below the federal poverty level have a twofold higher risk of diabetesrelated mortality compared with their counterparts in the highest family income levels (54). This pattern of diabetes-related mortality has been observed specifically in adults with T1DM as well (55). A meta-analysis by Bijlsma-Rutte et al. (56) observed an inverse association between income and $\mathsf { H b A } _ { 1 \mathsf { c } }$ levels in people with T2DM, with a pooled mean difference in $\mathsf { H b A } _ { 1 \mathrm { c } }$ o $\mathsf { \Omega } \mathsf { \Omega } ^ { \mathsf { f } } 0 . 2 0 \% \left( 9 5 \% \mathsf { C l } - 0 . 0 5 \right.$ to 0.46) between people with low and high income. Low income is associated with a higher risk of experiencing diabetic ketoacidosis among youth and adults with T1DM (57) and with higher $\mathsf { H b A } _ { 1 \mathrm { c } }$ levels, particularly among racial/ethnic minority youth with lower SES (58,59).

Education. Age-adjusted incidence of diagnosed diabetes in adults is associated also with educational level in a stepwise pattern. Diabetes incidence is highest (10.4 per 1,000 persons) for adults with less than a high school education, 7.8 per 1,000 persons for those with a terminal high school education, and 5.3 per 1,000 persons for those with more than a high school education (60). Diabetes prevalence in the adult U.S. population is similarly inversely associated with educational level in a stepwise pattern. In the U.S., the age-adjusted prevalence of diagnosed diabetes is $1 2 . 6 \%$ for those with less than a high school education, $9 . 5 \%$ for those with a high school education, and $7 . 2 \%$ for those with more than a high school education (61). Having a college education or more is associated with the lowest odds of diabetes (62). Mirroring findings on income, temporal trends in diabetes prevalence at different levels of education show increasing disparities in prevalence associated with educational attainment (50).

The risk of diabetes-related mortality demonstrates a gradient from lowest to highest education level. Compared with adults with a college degree or higher, having less than high school education is associated with a twofold higher mortality from diabetes (relative hazard 2.05, $9 5 \%$ CI 1.78–2.35) (54). In adults with T1DM, not having a college degree is associated with a threefold higher mortality from diabetes compared with counterparts with a college degree (63). Lower educational level is associated with higher ${ \mathsf { H b A } } _ { 1 \mathrm { c } } ,$ with a meta-analysis (56) reporting a pooled mean difference in $\mathsf { H b A } _ { 1 \mathsf { c } }$ of $0 . 2 6 \%$ $9 5 \%$ CI, 0.09–0.43) between people with low and high educational levels. Regarding literacy/health literacy as a SDOH, Marciano et al. (64) conducted a meta-analysis of 61 studies of 18,905 adults with T1DM or T2DM to determine associations of health literacy with several diabetes outcomes and found that higher levels of health literacy were significantly associated with lower $\mathsf { H b A } _ { 1 \mathrm { c } }$ levels and better diabetes knowledge, but not with more frequent self-management activities.

Occupation.Systematic reviews and metaanalyses have examined several aspects of occupation in relation to diabetes risk, although most of this research has been conducted outside of the U.S. Ferrie et al. (65) conducted a meta-analysis of associations of job insecurity with incident diabetes and found an association of high job insecurity with higher risk of incident diabetes (OR 1.19, $9 5 \%$ CI 1.09–1.30). A meta-analysis by Varanka-Ruuska et al. (66) found that unemployment was associated with increased odds of both prediabetes (OR 1.58, $9 5 \%$ CI $\pm . 0 7 -$ 2.35) and T2DM (OR 1.72, $9 5 \%$ CI 1.14–2.58). Exposure to shift work is associated with higher risk of diabetes than working normal daytime schedules (67). A meta-analysis by Kivimaki et al.¨ (68) reported an association of long work hours $\scriptstyle ( \geq 5 5 \ \mathsf { h }$ per week) as compared with standard work hours $( 3 5 - 4 0 ~ \mathsf { h }$ per week) with higher incident diabetes in adults with low SES but not in adults with high SES. A U.S. population-based survey on diabetes and occupation found highest prevalence of diabetes among transportation workers and lowest prevalence of diabetes among physicians (69,70).

To date, there is no body of literature describing impact of change in income, change to higher educational status, or different employment/occupational status on diabetes outcomes, although income and wage changes, and job changes and loss, do occur naturalistically. Similarly, no diabetes outcomes have been reported from interventions directly targeting living wages, early childhood education, educational quality, or educational access for poor children and families. Studies have examined diabetes selfmanagement interventions in the setting of low literacy/health literacy, particularly among racial/ethnic minority adults with T2DM and have demonstrated effectiveness of low-literacy adaptions (71) and health literacy and numeracy tools in improving diabetes knowledge and selfcare (72–74). A meta-analysis of nine intervention trials with 1,874 adults with T2DM found that literacy-sensitive interventions were associated with a small but statistically significant decrease in $\mathsf { H b A } _ { 1 \mathsf { c } }$ $( - 0 . 1 8 \%$ ; $9 5 \%$ CI $- 0 . 3 6$ to $- 0 . 0 0 4 )$ in comparison with usual clinical care (75) in patients regardless of health literacy status. Literacy-adapted education and tools may need to be combined with more comprehensive evidence-based behavioral self-management intervention approaches to achieve substantive clinical improvements in racial/ethnic minority populations with T2DM and low literacy/health literacy (76,77). In conclusion, despite the long-standingevidence for SES as a key determinant both of diabetes risk and outcomes, systematic investigation of impact on diabetes of change in SES remains a gap in the literature.

# Neighborhood and Physical Environment and Diabetes

The neighborhood environment in which one lives has been of major interest as a setting in which to understand contextual and multilevel influences on health (78).DiezRouxandMair (78)havedescribed the role of historical and contemporary residential segregation by race, ethnicity, and SES as the socioeconomic and political context that produced the patterns of unequal resource distribution resulting in neighborhood environments that maintain health inequities. Tung et al. (79) also discuss the multiple intricacies associated with how race, place, and poverty converge in a dynamic way across various spatial contexts and circumstances to influence health and propose that understanding the intersection of these contextual influences is needed to prevent diabetes inequities. Neighborhood and physical environment factors of housing, built environment, and environmental exposures are reviewed.

# Housing

Stable housing is a key indicator of economic stability (80) and a core SDOH (80). Housing instability refers to a spectrum of situations that can range from living in one’s car, staying with relatives or friends, having trouble paying rent, suffering evictions or frequent moves, paying more than $50 \%$ of income in rent, and living in crowded conditions (historically defined as having more than one person per room) to homelessnessdthe most extreme form of unstable housing (81–85). Homelessness is defined as “lacking a regular nighttime residence or having a primary nighttime residence that is a temporary shelter or other place not designed for sleeping” (86). As of 2020, the U.S. government reported 567,715 or 17 of 10,000 people in the country are homeless; African Americans accounted for $40 \%$ of people experiencing homelessness, while those identifying as Hispanic or Latino comprised $2 2 \%$ of the homeless population (87). A common theme in conceptual models linking housing instability to poor health is that the instability inherent to the situation makes it difficult to attend to preventive services and self-care (83,88–90), leading to worse control of chronic conditions, higher use of acute-care services like emergency departments, and higher likelihood of complications (91–93).

Associations of Housing Instability With Diabetes Incidence, Prevalence, and Outcomes. The prevalence of diabetes among those with housing instability in the U.S., and whether it differs from that among those without housing instability, is not known. A key limitation for the field is that there is no single, accepted definition of housing ment instrument. Further, because housing instability is more likely to occur among individuals with lower SESdwhich is independently associated with higher diabetes prevalenceditis unclearwhether housing instability is causally related to developing diabetes. One systematic review did not find higher diabetes prevalence than in the general population among persons experiencing homelessness, estimating approximately $8 \%$ prevalence in adults who do and do not experience homelessness (94). A recent study using nationally representative data from individuals seen in community health centers found that approximately $3 7 \%$ of individuals with diabetes reported housing instability. This study also found that individuals with diabetes and housing instability were more likely to self-report having an emergency department visit or hospitalization for their diabetes (adjusted OR 5.17, $9 5 \%$ CI 2.08– 12.87) (82). A cross-sectional study in a single health care system found that housing instability among individuals with diabetes was associated with higher outpatient utilization (incident rate ratio 1.31, $9 5 \% { \mathsf { C l } } 1 1 . 1 4 { - } 1 . 5 1$ ) (95). Though not specific to diabetes, additional work has linked housing instability to poor health outcomes and reduced health care access (91,96–100). A longitudinal study in the Department of Veterans Affairs (VA) health care system found that experiencing homelessness was associated with higher adjusted odds of having an $\mathsf { H b A } _ { 1 \mathsf { c } } > 8 . 0 \%$ and $5 9 . 0 \%$ Vijayaraghavan et al. (84) identified unstable housing as a key barrier to diabetes careamonglow-incomeindividuals.There was an observed linear decrease in diabetes self-efficacy as housing instability increased $\mathrm { . } \mathsf { \Gamma } \mathsf { \beta }$ -coefficient $- 0 . 9 4$ , $9 5 \%$ C I $- 1 . 8 8$ to $- 0 . 0 1$ , $P < 0 . 0 1$ ), which was partially mediated by food insecurity. Qualitative work has found that unstable housing makes it more difficult to engage in self-care, follow self-management routines, afford diabetes medications and supplies, and eat healthy foods (91,92). Choice of medication is important, and considerations should include medication cost and the ability to store medication and diabetes care supplies safely. Brooks et al. provide a narrative review of considerations for diabetes treatment among individuals experiencing homelessness (101).

outcomes are few; however, there is some high-quality evidence for housing interventions. The Moving To Opportunity forFairHousingDemonstration Project (MTO), a randomized social experiment conducted through the Department of Housing and Urban Development, in partnership with behavioral scientists and other federal agencies, was designed to determine what impact moving from a high-poverty to a low-poverty census tract would have on multiple outcomes (102,103). In 1994–1998, MTO randomized 4,498 women with children living in public housing within high-poverty census tracts in five cities to one of three study arms. The 1,788 women in the experimental arm received Section 8 vouchers usable only in low-poverty areas (census tracts with $< 1 0 \%$ of the population below the poverty line) along with counseling and assistance in finding a private rental unit. The 1,312 women in the Section 8 arm received traditional unrestricted vouchers and the usual briefing the local Section 8 program provided. The 1,398 women in the control arm received no vouchers but continued to receive MTO project-based assistance. Those who received vouchers could choose whether to use the vouchers or not. Findings from the follow-up survey in 2008 through 2010 found a $2 1 . 6 \%$ relative reduction in prevalence of an elevated $\mathsf { H b A } _ { 1 c } ( > 6 . 5 \% )$ in the group that moved to low-poverty census tracts compared with the control group, with an absolute difference of 4.31 percentage points $( 9 5 \% \textsf { C l } - 7 . 8 2$ to $- 0 . 8 0 )$ . The low-poverty group also had relative reductions of $1 3 . 0 \%$ in prevalence of ${ \mathsf { B M I } } \geq 3 5$ and relative reduction of $1 9 . 1 \%$ in $\mathsf { B M I } \ge 4 0 ~ \mathsf { k g } / \mathsf { m } ^ { 2 }$ , with absolute differences of 4.61 percentage points $( 9 5 \%$ CI $- 8 . 5 4$ to $- 0 . 6 9 )$ and 3.38 percentage points $\lvert 9 5 \% \mathsf { C l } - 6 . 3 9$ to $- 0 . 3 6 )$ , respectively (102). The usual vouchers and control arms did not differ. Other MTO outcomes among the group randomized to low-poverty census tracts included higher housing quality, education, employment, and earnings as well as multiple additional improvements to child and adult health (103). A 10–15 year follow-up study found substantial and sustained reductions in diabetes prevalence, rates of extreme obesity, and improvement in mental health outcomesamong theadults who received vouchers to move to lowpoverty neighborhoods and reduction in extreme obesity among the adults who received Section 8 vouchers (104). While not specific to diabetes, a meta-analysis of randomized trials that provided low-barrier housing support for individuals experiencing homelessness found significant reductions in health care utilization (105).

Housing interventions may facilitate access to diabetes care. The Collaborative Initiative to End Chronic Homelessness provided adults whowere chronically homeless with permanent housing and supportive primary health care and mental health services (106). Placed persons were more likely to receive evaluation and management services (relative risk [RR] 1.03, $9 5 \%$ CI 1.01–1.04) than unplaced persons (107). Placed persons were more likely to receive $\mathsf { H b A } _ { 1 \mathsf { c } }$ tests (RR 1.10, $9 5 \%$ CI 1.02–1.19) and lipid tests (RR 1.09, $9 5 \%$ CI 1.02–1.17), while for those without baseline diabetes placement was associated with lower risk of new diabetes diagnoses (RR 0.87, $9 5 \%$ CI 0.76–0.99). Keene et al. (91) suggest the relationship of stable housing to diabetes management is due to its role as a foundation for prioritizing care and allowing for the routinization of diabetes management, critical to disease control. This suggests the benefits of supportive and stable housing may be extended to diabetes care and prevention. A naturalistic qualitative study of the impact of transitioning to rental-assisted housing among lowincome, housing-insecure adults with T2DM reported that rental assistance afforded individuals more environmental and financial control over life circumstances, thereby enabling diabetes routines and allocation of financial resources to diabetes care (108).

# Built Environment

The built environment, as defined by the U.S. Centers for Disease Control and Prevention (CDC), includes the physical parts of where people live and work, such as infrastructure, buildings, streets, and open spaces (109). Here, built environment factors of walkability and greenspace are reviewed.

Associations of Built Environment with Diabetes Incidence, Prevalence, and Outcomes. A robust literature has demonstrated associations of the built environment with ment $( \beta = - 0 . 0 4 0 )$ and neighborhood activities $( \beta = - 0 . 1 0 4 )$ ) with exercise in a southeastern U.S. population with diabetes. A recent U.S. review and metaanalysis by Chandrabose et al. (113) examined longitudinal studies of the built environment and cardiometabolic health. Results showed strong evidence for impact of walkability on T2DM outcomes, with four of seven studies $( 5 7 \% )$ showing significant findings in the aggregated analyses using objective and perceived measures of walkability. Although the methods to determine mediation by physical activity in most studies were ineffective to make conclusions, one study tested the indirect effect of walkability on 10-year change in $\mathsf { H b A } _ { 1 \mathsf { c } }$ and found a partial mediation effect for self-reported physical activity using structural equation modeling. For other measures of built environment, such as neighborhood recreational facilities or destinations/routes, there was insufficient data to examine the relationship with T2DM outcomes. A larger body of research on built environment and diabetes has been conducted in countries outside of the U.S (110–112). In these studies, neighborhood physical activity (PA) environments, specifically better walkability of neighborhoods and access to greenspace, have been consistently associated with lower risk of T2DM and better outcomes (115,116). Numerous studies have been conducted on walkability measured by macroscale aspects of the neighborhood, including higher population density, land use mix, and aesthetics, to microscale aspects, including sidewalks, street connectivity, and street safety. A review by Bilal et al. (115) on walkability and diabetes incidence and prevalence found that more walkable neighborhoods are associated with a lower incidence and prevalence of T2DM. Similarly, Twohig-Bennett and Jones (117) conducted a systematic review and meta-analysis examining the relationship to diabetes outcomes of “high” and “low” exposure to greenspace in neighborhoods (defined as open, undeveloped land with natural vegetation and/or spaces such as parks and tree-lined areas). The meta-analysis, representing 462,220 participants, showed an association of high exposure with reductions in the incidence of T2DM (OR 0.71, $9 5 \%$ CI 0.61–0.85) (117). After decades of research, many built environment factors related to PA and obesity risk have been identified for consideration in urban planning (118).

Neighborhood-Level Interventions on the Built Environment and Diabetes Outcomes. Because it is often not feasible or ethical to randomize neighborhoods to receive certain structural interventions, natural experiment designs are used in which the researcher does not control or withhold intervention allocation to particular areas; rather, natural or predetermined variation in allocation occurs, often as a result of policy intervention (119). Several review articles of natural experiments summarize the benefits of policy and built environment changes on obesity-related outcomes (112)and diet and PA outcomes (120,121).The strongestdiet-related studies were those that evaluated regulations to the food environment, and the strongest PA-related studies were those that improved infrastructure for active transport. Although this literature does not directly address diabetes outcomes, improvements in obesity and diet and PA behaviors are relevant to populations with diabetes and warrant rigorous evaluation (122).

# Toxic Environmental Exposures

Toxic environmental exposures can be naturally occurring (e.g., arsenic in private wells, radon) or introduced into the environment through human activity (e.g., pollution, synthetic pesticides) (123). Marginalized communities in the U.S. are disproportionately exposed to environmental agents that have evidence of an association with diabetes, including air pollution, environmental toxicants, and ambient noise (124–129), and subgroups that generate the least pollution have highest exposures (130).

Factors contributing to inequities in toxic environmental exposures include residential segregation and inequity in goods and services, due in part to systemic racism in environmental regulation and opportunities (128,130–133). Explanatory factors are closer proximity of underserved neighborhoods to nearby pollution sources, poor enforcement of regulations, and inadequate response to community complaints (134–138). In rural and suburban communities, including Native American Indian communities, unregulated private wells are a source of water contaminants including arsenic and other metals/metalloids, pesticides, and hazardous chemicals, affecting millions of people (139–141). Both food packaging and fast-food consumption, which can be high in low-income neighborhoods, can expose people to chemicals known to be endocrine disrupters (142–145). Examples include chemicals released from plastic packaging during microwave heating (142), higher urinary phthalate levels associated with fast food (145), and higher urinary bisphenol A levels from canned foods (146). Certain personal care and cosmetic products, which are a source of phthalates and metals (e.g., skin-lightening products, which are high in mercury), are disproportionately marketed to marginalized population subgroups (147).

<html><body><table><tr><td rowspan="2">Commission on the Social Determinants of Health, WHO (2008) (27)</td><td> Improve daily living conditions</td><td>Put major emphasis on early childhood education and development. Improve living and working conditions. Create social protection policy supportive of all.</td></tr><tr><td>Tackletheineqabledistrtifpoweoeydeatetrogpublctotatisoitedableddeqatelcure resources</td><td>legitimacy,space,andsupportfor civil society,foranaccountable privatesector,and forthe public to agree to reinvestment in collective action. MeasureandunderstandtheproblemandassestheAcknowledgethereisaproblem.EnsurethathealthinequityismeasuredDevelopnational</td></tr><tr><td>Committee on Recommended Social and Behavioral Domains and Measures for Electronic Health</td><td>impact of action Standardize data collection and measurement to facilitate the critical use and exchange of information</td><td>and global health equity surveillance systems for routine monitoring of health inequity and the social determinants of health. Evaluate the health equity impact of policy and action. Ensure stronger focus on social determinants in public health research. Office ofthe National Coordinator for Health Information Technologyand the CMSshould include the recommended standardized measures in the certification and meaningful use regulations:</td></tr><tr><td>Records, Institute of Medicine, NASEM (2014) (80) Committee on Educating Health Professionals to</td><td> on social and behavioral determinants of health</td><td>Commonly used measures: race and ethnicity,* residentialaddress,* alcohol use,tobacco use Additional recommended measures: census tract-median income,* education,* financial resource strain,* social connections and social isolation,* depression,intimate partner violence, physical activity， stress Createalearingenvometfoealthprofessoalstoealthprofessoaleducatorssouldceatelifelonglarersoprecatetealueof relationships and collaborations for understanding and addressing community-identified</td></tr><tr><td rowspan="2">Address the Social Determinants of Health, NASEM (2016) (301)</td><td>foster community collaborations Prepare health professionals to take action on SDOH</td><td>needs and for strengthening community assets. To prepare health professionals totakeactionon thesocial determinants ofhealth in, with,and across communities, health professional and educational associations and organizations at</td></tr><tr><td></td><td>the global, regional, and national levels should apply [frameworks for] partnering with communities to increase the inclusivity and diversityofthe health professionalstudent body and faculty. IntegrateSOintganatialmssanduGvementsndndidalnistries(eignatorsoftheiaatilt professional and educationalassociations and organizations,and community groups should</td></tr><tr><td rowspan="2">and evaluation approaches</td><td></td><td>foster an enabling environment that supports and values the integration of the social determinants framework principles into their mission, culture, and work. Buildthevdeesefoneeientsaltofeialducatilotiodsd community organizations should use[asocial determinants] framework and modelto guide</td></tr><tr><td>Cmite</td><td>and support evaluation research aimed at identifying and ilustrating efective approaches for learning about the social determinants of health in and with communities while improving health outcomes, thereby building the evidence base. needs. Incorporate strategies for screening and assessing for social risk factors and needs.</td></tr><tr><td rowspan="2">Delivery of Health Care to Improve the Nation&#x27;s Health, NASEM (2019) (5)</td><td>health care, guided by the five health care system activities—awareness, adjustment, asstance, alignment, and advocacy</td><td>Incorporate social risk into care decisions using patient-centered care. Establish linkages between health care and social service providers. Include social care workers in team care. Develop infrastructure for care integration, including financing of referralrelationships with</td></tr><tr><td>BuildaworkforcetointegratesocialcarentohalthcareSocialworkersandothersocialcareworkforcesshouldbeproviderseligiblefor delivery</td><td>select social providers. reimbursement from payers. Integrate SDOH competencies in medical and health professional credentialing.</td></tr></table></body></html>

<html><body><table><tr><td rowspan="4">Committee</td><td>Recommendedactions Develop a digital infrastructure that is interoperable between health care and social care organizations</td><td>Description Establish ACA-recommended digital infrastructure for social care. The Office of the National Coordinatorshould supportidentification of interoperable,secure,platforms for use across</td></tr><tr><td></td><td>health and social care communities. The Federal Health Information Technology Coordinating Committee should facilitate data sharing across domains (e.g.，health care, housing,and education). Analytic and technology implementation must have an explicit focus on equity to avoid unintended consequences such as perpetuation or aggravation of discrimination, bias,and marginalization.</td></tr><tr><td>Finance the integration of health care and social care</td><td>CMS should define and use flexibility in what social care constitutes Medicaid-covered services. Health systems, payers, and governments should consider colective financing to spread risk and create shared returns on investments in social care.Health systems subject to community benefit regulations should comply with those regulations and should align their hospital licensing requirements and public reporting with community benefits</td></tr><tr><td>the effectivenessand implementation of social care practices in health care settings</td><td>regulations and should link their community benefits providing social care. Fundcodcteddeaee foundations should contribute to advancing research and evaluation of social care through funding opportunities, researcher support (i.e., cultivate health services, social sciences, andcross-disciplinary researchers),and use of experimentaltrials,rapidlearning cycles,and dissemination of learnings.CMS should fully finance independent state waiver evaluations</td></tr></table></body></html>

Associations of Environmental Risk Factors With Diabetes Incidence, Prevalence, and Outcomes. In 2011, the National Toxicology Program at the National Institute of Environmental Health Sciences convened an international workshop to evaluate the experimental and epidemiologic evidence on the relationship of environmental chemicals with obesity, diabetes, and metabolic syndrome (148–150). Evidence was deemed strongest for arsenic, with relative risks of diabetes found to range from 1.11 to 10.05 in different studies (median 2.69) at high arsenic exposure levels. More recent systematic reviews and meta-analyses present the growing literature examining multiple groups of chemicals (148,151) or specific groups of chemicals (152–154). Overall, the evidence supports an increased risk of diabetes in populations exposed to environmental chemicals including arsenic, persistent organic pollutants, phthalates, and possibly bisphenol.

In 11 prospective studies of air pollution exposure and incident diabetes in adults, the pooled hazard ratio (HR) $1 9 5 \%$ CI) per $1 0 ~ \mu \mathrm { g } / \mathsf { m } ^ { 3 }$ increment particulate matter of $< 2 . 5 ~ { \mu \mathrm { m } }$ aerodynamic diameter was 1.10 (1.04–1.17) (155). Other reviews have reached conclusions consistent with this increased diabetes risk finding (156–158). The epidemiologic evidence is also supported by animal experiments showing that air pollution exposure can increase susceptibility to insulin resistance and T2DM (159–161). These findings highlight that populations more exposed to air pollution are also disproportionately at risk for developing diabetes.

There is epidemiologic and experimental evidence that environmental exposures increase susceptibility to cardiovascular disease (CVD) in people with diabetes. The evidence is extensive for air pollution exposures (162,163). For example, in Medicare patients, a daily increase of $1 0 \mathrm { \textrm { \textmu } g } / \mathrm { m } ^ { 3 }$ in particulate matter $< 1 0$ $\mu \mathsf { m }$ of aerodynamic diameter was associated with $2 . 0 1 \%$ increase in CVD hospitalizations for those with diabetes compared with $0 . 9 4 \%$ increase among those without diabetes (162). Short-term increases in air pollution exposure are also related to higher risk of stroke mortality in patients with diabetes compared with those without (164). In an experimental model, mice with diabetes exposed to diesel exhaust particles showed increased cardiovascular susceptibility compared with mice without diabetes (165). In natural experiments in human populations, air pollution exposure also resulted in increased vascular reactivity (166) and inflammation in patients with diabetes compared with those without (167). In addition to air pollution, some evidence is also available for metals. In the Strong Heart Study of American Indian adults followed since 1989–1991, the risk of CVD associated with higher exposure to arsenic and cadmium was higher among participants with diabetes compared with those without diabetes (168,169). In a clinical trial in patients with a previous myocardial infarction (Trial toAssess ChelationTherapy [TACT]), the beneficial effects of repeated chelation with disodium edetate on cardiovascular outcomes were greater in patients with diabetes (170).

Environmental Exposures Interventions and Diabetes. Few studies have evaluated the effect of population-based or clinical interventions related to environmental exposures and diabetes prevention or control. The increased risk of diabetes in populations exposed to environmental chemicals and the increased susceptibility for diabetes complications in individuals with diabetes exposed to air pollution potentially provides an opportunity for prevention and treatment that can be particularly relevant for the most vulnerable populations. For example, a comparison of preterm births among four studies in different countries, before and after the implementation of smoke-free legislation, has shown reductions in diabetes risk (pooled risk change $- 1 8 . 4 \%$ , $9 5 \%$ CI 218.8 to $- 2$ ), although the long-term benefits have not yet been evaluated (171).

Because individuals generally have limited control over environmental agents, the most effective interventions will be at the population level, through policy and regulation, with a particular focus on protecting marginalized and underserved populations. There is evidence that declines in air pollution levels and metal exposures have contributed to improvements in CVD development (172,173); benefits for diabetes development are pending. Research is also needed to test intermediate strategies at the clinical level, such as exposure screening (e.g., asking about living near highways or using private wells for drinking water) and recommendations to test air or water, reduce known sources of exposure (e.g., minimize packaged foods, avoid heating food in plastic containers, and minimize use of certain cosmetic products), and make home interventions (e.g., install filters for air or water contaminants) (174–176).

# Food Environment and Diabetes

The food environment can be defined as the physical presence of food that affects a person’s diet; a person’s proximity to food store locations; the distribution of food stores, food service, and any physical entity by which food may be obtained; or a connected system that allows access to food (177). It is the “collective physical, economic, policy and sociocultural surroundings, opportunities and conditions that influence people’s food and beverage choices and nutritional status” (178). It is also referred to as the community food environment (e.g., number, type, location, and accessibility of food outlets such as food stores, markets, or both) and the consumer-level environment (e.g., healthful, affordable foods in stores, markets, or both), which interact to affect food choices and diet quality (179,180). Key dimensions of the food environment include accessibility, availability, affordability, and quality (181–184). These factors, which define the quality of the food environment, are of particular importance in marginalized communities, which may have poor access to supermarkets and healthy foods but abundant access to fast-food outlets and energydense foods and are often disproportionately impacted by physical hazards (e.g., vacant houses, traffic, and crime) (78). At their root, differences in the food environment can be caused by government policies and incentives, and the legacy of such policies as redlining and segregation.

Table 4—Examples of resources on SDOH available for health care organizations and health care professionals   

<html><body><table><tr><td colspan="2">Table4-ExamplesofresourcesonSDOHavaiableforheaithcareorganizationsandheaithcareprofessonals Organization Resource</td></tr><tr><td>Centers for Disease Control and Prevention (CDC)</td><td>Tools for Putting Social Determinants of Health Into Action (https://www.cdc.gov/ socialdeterminants/tools/index.htm)</td></tr><tr><td rowspan="2">National Academies of Science, Engineering, and Medicine</td><td>Questions for conducting socialand behavioraldeterminantassessment and frequencies for assessing</td></tr><tr><td>Adler NE, Stead WW. Patients in context—EHR capture of social and behavioral determinants of health. N Engl JMed 2015;372:698-701. DOl: 10.1056/NEJMp1413945 The Neighborhood Atlas-Free social determinants of health data for all!</td></tr><tr><td>National Institutes of Health (NIH) Division of Extramural Affairs American Academy of Family Physicians</td><td>Kind AJH, Buckingham W. Making neighborhood disadvantage metrics accessible: the neighborhood atlas. N Engl J Med 2018;378:2456-2458. PMCID: PMC6051533 The EveryONE Project&#x27;s Neighborhood Navigator Toolkit (htps://www.afp.org/patient-</td></tr><tr><td></td><td>care/social-determinants-of-health/everyone-project/neighborhood-navigator/ training-videos.html)</td></tr><tr><td>American College of Physicians American Medical Association</td><td>Addressing Social Determinants to Improve Patient Care and Promote Health Equity: An American College of Physicians Position Paper. DOl: 10.7326/M17-2441 Podcast: Social determinants of health: What they are and what they aren&#x27;t (https://www</td></tr><tr><td></td><td>.ama-assn.org/delivering-care/patient-support-advocacy/social-determinants-health- what-they-are-what-they-arent)</td></tr><tr><td rowspan="2">Nonprofit services</td><td>211: A service of the United Way that continuously identifies links for all &quot;211&quot; health and human services referral services in the U.S. HealthLeads: A nonprofit ofering tools,training and resources for integrating SDOH into</td></tr><tr><td>accountable care Aunt Bertha: A service that provides links to hundreds of programs serving every U.S. zip code. Free basic use.</td></tr></table></body></html>

# Associations of Food Environment With Diabetes Incidence, Prevalence, and Outcomes

FoodAccessandAvailability.Cross-sectional studies have shown associations between food access, availability, geographic characteristics, and T2DM prevalence. Ahern et al. (185) examined 3,128 counties across the U.S. for food access (assessed as percent of households with no car living more than one mile from a grocery store) and food availability (assessed as number of fast-food restaurants, full-service restaurants, grocery stores, convenience stores, and per capita sales in dollars from local farms made directly to consumers). Higher access to food was associated with lower T2DM rates in metro and nonmetro counties, and higher availability of fullservice restaurants and grocery stores and lower availability of fast-food and convenience stores were associated with lower diabetes rates (185). Haynes-Maslow and Leone (186) similarly found availability of full-service restaurants to be associated with lower prevalence of diabetes in adults and availability of fast-food restaurants generally to be associated with higher diabetes prevalence. However, the study reported variability in associations among numerous food environment characteristics based on county composition (low poverty/low minority, low poverty/ medium minority, high poverty/low minority), highlighting complexities in understanding patterns among variables of county socioeconomic status, demographics, food availability, and diabetes prevalence (186).

Several observational, longitudinal studies report neighborhood resources in general, and access and availability of the food environment in particular, as associated with diabetes prevalence and incidence (187). A systematic review by den Braver et al. (188) found availability of fast-food outlets and convenience stores to be associated with higher T2DM risk/prevalence and perceived healthfulness of the food environment to be associated with lower diabetes risk/ prevalence, but no association was found between density of grocery stores and T2DM risk/prevalence. Heterogeneity across the studies prevented the conduct of meta-analyses. Gabreab et al. (189)

examined neighborhood, social, and physical environments and T2DM in 3,700 African Americans through the Jackson Heart Study and found higher density of unfavorable food stores was associated with a $34 \%$ higher T2DM incidence after adjusting for individuallevel risk factors. In a longitudinal employee cohort, Herrick et al. (190) found that living in a zip code with higher supermarket density was associated with a reduction in T2DM risk, while zip codes with a higher percentage of poverty and zip codes with higher walkability scores were both associated with higher diabetes risk. Christine et al. (191) reported long-term exposure to residential environments that offer resources to support healthy diets and PA was associated with a lower incidence of T2DM, although results varied by measurement method.

Studies have also examined both food and PA environments in combination and diabetes risk. Meyer et al. (192) combined measures of neighborhood food and PA environments and weight-related outcomes $( N = 1 4 , 3 7 9 )$ of the Coronary Artery Risk Development in Young Adults (CARDIA) study, examining population density–specific (less than vs. greater than 1,750 people per square kilometer) clusters of neighborhood indicators: road connectivity, parks and PA facilities, and food stores/restaurants. In lower– population density areas, higher food and PA resource diversity relative to other clusters was significantly associated with higher diet quality (192). In higher– population density areas, a cluster with relatively more natural food/specialty stores, fewer convenience stores, and more PA resources was associated with higher diet quality. Neighborhood clusters were inconsistently associated with BMI or insulin resistance and not associated with fast-food consumption, or walking, biking, or running (192). Tabaei et al. (193) examined associations of residential socioeconomic, food, and built environments with glycemic control in adults with diabetes ascertained from the New York City A1C Registry from 2007 to 2013. Individuals who lived continuously in the most advantaged residential areas, including greater ratio of healthy food outlets to unhealthy food outlets and residential walkability, achieved increased glycemic control and took less time to achieve glycemic control compared with the individuals who lived continuously in the least advantaged residential areas (193).

<html><body><table><tr><td colspan="2">Table 5-SDOH and diabetes research recommendations Research recommendation 1 Consensus is needed around language and metrics associated with SDOHand Establish consensus core SDOH definitions and metrics</td></tr><tr><td>Research recommendation 2 Examine specificities in SDOH pathways and impacts among different populations with diabetes</td><td>diabetes care that move beyond health care and capture the impact of social advantage and disadvantage in population settings. Clarity and consistency in measurement, evaluation,and reporting of progress wil allow for appropriate planning of interventions, allocation of resources, and analysis of impact in achieving equity goals. Examinations of potential differences in pathways or impacts of SDOH based on characteristics including diabetes type or diagnostic category (e.g.,</td></tr><tr><td>Research recommendation 3</td><td>T1DM vs. T2DM,gestational diabetes melitus, prediabetes),，age group (e.g., children and youth,adults,older adults),and different SES (wealthy vs. middle class vs. poor) are needed. In addition, complexities of SDOH pathways and impacts for different racial/ethnic groups, based on historical drivers and policies, warrant elucidation to inform intervention and mitigation strategies. Multisector partnerships,comprisingacademic institutions,government</td></tr><tr><td>Prioritize a next generation of research that targets SDOH as the root cause of diabetes inequities</td><td>sectors (e.g.,housing, education, justice),and public health entities are required in orderto design and testobservational and intervention studies to better understand and intervene on SDOH as root causes of diabetes disparities. Priorities need to move from compensatory to the next- generation of research that will be larger in scope, addressing foundational causes of disparities (e.g.， policy， systems change),and tested over time across sectors.Complex studies,examining the interactive effects of multifaceted systems that influence SDOH,will also transform and move translational efforts toward large-scale solutions that promote equity for al populations and mitigate the influence of SDOH on diabetes outcomes.</td></tr><tr><td rowspan="2">Research recommendation 4 Use dissemination and implementation science to ensure SDOH considerations are embedded within diabetes research and evaluation studies</td><td>For clinical research programs, dissemination and implementation methods will shorten the translation gap from discovery to impact of evidence- based interventions by addressing the complexity of integrating and adapting evidence-based practices to real-world community and clinical settings. This will assure all populations benefit from the billions of U.S.tax dollars spent on research to prevent diabetes and to improve diabetes</td></tr><tr><td>population health. Research studies must also consider the potential influence of either positive or negative SDOH (e.g., wealth or economic security vs. poverty, food security vs. insecurity, stable vs. unstable housing) on intervention appropriateness and outcomes, on study recruitment and participation, and on study outcomes and conclusions.</td></tr><tr><td>Research recommendation 5 Train researchers in methodologies and experimental techniques for multisector and next generation SDOH intervention studies</td><td>Training on SDOH and their influence on diabetes prevention and treatment is needed.Training priorities include interdisciplinary science,multisector collaboration research approaches,and methods to advance root cause research on SDOH. Additionally,increasing diversity among research workforces, and fostering educational experiences encompassing multisector partners will develop a workforce that is congruent with promoting diabetes health equity.</td></tr></table></body></html>

Food Affordability. Kern et al. (194) note that it is reasonable to expect that large differences in price between healthy and unhealthy foods would lead to differences in purchasing patterns and resulting diets and that those differences would be more prominent for individuals of lower SES. In a longitudinal study, they examined food affordability and neighborhood price of healthier food relative to unhealthy food and its association with T2DM and insulin resistance. Higher prices of healthy foods relative to unhealthy foods were found to be associated with lower odds of having a high-quality diet; however, there was no association with diabetes incidence or prevalence (194). More studies are needed in this area.

quality of food at all times for all household members to have an active, healthy life (195,196). Approximately $20 \%$ of diabetes patients report household food insecurity (197), and food insecurity is a risk factor for poor diabetes management (196). Researchers have investigated several pathways through which food insecurity may worsen T2DM outcomes (198–200). First, in the nutritional pathway, food insecurity is associated with lower diet quality (201), which is in turn associated with higher $\mathsf { H b A } _ { 1 \mathrm { c } }$ . Food insecurity incentivizes more affordable, energy-dense foods that can directly raise serum glucose (e.g., refined carbohydrates, processed snacks and sweets, sugar-sweetened beverages, etc.) and may lead to greater insulin resistance (202,203). Conversely, low or inconsistent food availability can increase risk of hypoglycemia. Second, via a compensatory pathway, behavioral strategies necessary to cope with the immediate problem of food insecurity can inadvertently undermine T2DM management. For example, financial resources that might otherwise have been used for medications or diabetes care supplies are diverted to meet dietary needs (197,204–206). Third, through the psychological pathway, the state of food insecurity, in which meeting basic needs is outside an individual’s control, undermines self-efficacy and increases depressive symptoms and diabetes distress (207–210). Several studies have reported a relationship between food insecurity and adverse diabetes outcomes (211,212), and a review by Barnard et al. (213) has suggested that food insecurity among patients with and at high risk for T2DM may be particularly toxic because, in addition to issues of accessing sufficient calories overall, the dietary quality of the foods eaten is even more important than for the general population. Several crosssectional studies report a relationship between food insecurity and T2DM diabetes outcomes (214–216), including poor metabolic control (217,218), experience of severe hypoglycemia in lowincome and low-education samples (218), lower diabetes self-management behavioral adherence and worse glycemic control (219), and increased outpatient visits but not increased emergency department/ inpatient visits (95,212).

# Food Environment Interventions and Diabetes

Three studies reported food bank and pantry interventions with food insecure clients with T2DM (196,220,221). Seligman et al. (196) conducted a pilot program in Texas, California, and Ohio with a pre/post design, encompassing provision of diabetes-appropriate food, blood glucose monitoring, self-management support, and primary care referrals. The study resulted in improvements in ${ \mathsf { H b A } } _ { 1 \mathsf { c } } ,$ fruit and vegetable consumption, selfefficacy, and medication adherence. In a randomized controlled trial of the intervention, Seligman et al. (220) found improvements in nutritional consumption, food security, and distress but no clinical changes. Palar et al. (221) found reduction in BMI but not $\mathsf { H b A } _ { 1 \mathsf { c } }$ and better nutritional and psychosocial outcomes.

Studies have examined effect of supermarket gain or loss on T2DM outcomes. A study conducted within the setting of the Kaiser Permanente Northern California Diabetes Registry linked clinical measures to metrics from a geographic information system based on participants’ residential addresses (115,222,223). Results over 4 years of tracking supermarket change in low-income neighborhoods showed that relative to no change in supermarket presence, supermarket loss was associated with worse ${ \mathsf { H b A } } _ { 1 { \mathsf { c } } }$ trajectories, especially among those with highest $\mathsf { H b A } _ { 1 \mathsf { c } }$ . Supermarket gain in neighborhoods was associated with marginally better $\mathsf { H b A } _ { 1 \mathsf { c } }$ outcomes, but only for those with near-normal $\mathsf { H b A } _ { 1 \mathsf { c } }$ baseline values (223). In a natural experiment design, the Pittsburgh Hill/Homewood Study on Eating, Shopping, and Health (PHRESH) tested the effects of adding a supermarket, along with other neighborhood investments, on cardiometabolic risk factors among a randomly selected cohort of residents from two low-income, urban, and predominately African American matched neighborhoods (222,224). Results for the intervention neighborhood (receiving the supermarket) showed improved perceived access to healthy food (225), and the prevalence of diabetes increased less in the neighborhood with the supermarket than in the comparison neighborhood. Since the initiation of the supermarket, many other investments including greenspace, housing, and commercial spaces have been implemented in the intervention neighborhood (226).

Results of these neighborhood investments on measured BMI, blood pressure, ${ \mathsf { H b A } } _ { 1 \mathsf { c } } ,$ and HDL cholesterol will be forthcoming. In sum, food environment factors of food unavailability, inaccessibility, and insecurity each demonstrate associations with worse diabetes risk and outcomes, and interventions including diabetes-targeted food and self-management care at food banks and pantries and increasing grocery store presence in low-income neighborhoods are few, but collectively they demonstrate the potential to impact diabetes risk, clinical outcomes, and psychosocial outcomes.

# Health Care and Diabetes

Health care as a SDOH includes access, affordability, and quality of care factors. In the U.S., these factors are highly correlated with race/ethnicity, SES, and place/ geographic region (19).

# Associations of Health Care With Diabetes Incidence, Prevalence, and Outcomes

Access. In population-based studies, having health insurance is the strongest predictor of whether adults with diabetes have access to diabetes screenings and care (227). Uninsured adults in the U.S. population have a higher likelihood of having undiagnosed diabetes than adults with insurance (228). Compared with insured adults with diabetes, the uninsured have $60 \%$ fewer office visits with a physician, are prescribed $52 \%$ fewer medications, and have $16 8 \%$ more emergency department visits (229). Liese et al. (230) found that, among adolescents and young adults with T1DM or T2DM, compared with having private insurance, having state or federal health insurance was associated with higher $\mathsf { H b A } _ { 1 \mathsf { c } }$ values by $0 . 6 8 \% ,$ and having no insurance was associated with higher $\mathsf { H b A } _ { 1 \mathsf { c } }$ by $1 . 3 4 \%$ . Having insurance has also been found to attenuate associations of financial barriers with higher $\mathsf { H b A } _ { 1 \mathrm { c } }$ (231).

Geographic access to adult and pediatric endocrinologists varies substantially by state and county in the U.S (232), with disparities in access in many of the geographic regions with highest diabetes prevalence and socioeconomic disadvantage (232,233). Similarly, factors that increase odds of having a diabetes selfmanagement education program in a geographic area include a higher percentage of the population with at least a high school education, a higher percentage of insured individuals, and a lower rate of unemployment (234). DeVoe et al. (235) found that among adults with diabetes, having both insurance and a usual source of care, rather than one or the other, conferred the greatest odds of receiving at least minimum diabetes health care. Being uninsured and without a usual source of care was associated with three to five times lower odds of adults receiving an $\mathsf { H b A } _ { 1 \mathsf { c } }$ screen, blood pressure check, or access to urgent care when needed (235). Among adolescents and young adults with diabetes who had state or federal health insurance, not having any usual source of provider (primary care or diabetes specialist) was associated with higher $\mathsf { H b A } _ { 1 \mathsf { c } }$ than having a usual source of provider, and $\mathsf { H b A } _ { 1 \mathrm { c } }$ was similar whether in primary care or specialist care (230).

Affordability. On average, health care costs of people with diabetes are 2.3 times those of people without diabetes (229). Approximately $1 4 \%$ to $20 \%$ of adults with diabetes report reducing or delaying medications due to cost (236–238). Among adults with diabetes who are prescribed insulin, rates may be $> 2 5 \%$ (236,239). Cost-related or costreducing nonadherence (CRN) is associated with income, insured status, and type of insurance. Adults with diabetes with an annual household income of $< \$ 50,000$ are more likely to engage in CRN than their counterparts with income $\geq \$ 50,000$ , and uninsured adults with diabetes are more likely to engage in CRN than those with insurance (236). Within a diabetes clinic population of adults with T1DM or T2DM prescribed insulin, odds of CRN were three times higher for those with Medicaid or no insurance compared with those with Medicare (239). Piette et al. (240) found differences based on health system model. Compared with VA patients with diabetes, risk of CRN was found to be almost three times higher for privately insured patients and four to eight times higher for patients with Medicare, Medicaid, or no health insurance (240). Higher financial stress, financial insecurity, and financial barriers are associated with likelihood of CRN (231,238). People with CRN experience poorer diabetes management, higher ${ \mathsf { H b A } } _ { 1 \mathsf { c } } ,$ and decreased functional status (231,240). Deaths have been reported from insulin CRN among youth and adults with T1DM (241).

Quality. Having insurance is the strongest single predictor of whether adults with diabetes are likely to meet individual quality measures of diabetes care (242). Sociodemographic disparities in care quality are well documented in national reports and recommendations (2) and appear to remain consistent over time (243). In a U.S. population-based study of achievement of a composite diabetes treatment goal from 2005 to 2016, data from 2013 to 2016 showed that non-Hispanic Blacks had lower odds of achieving a composite diabetes quality measure than non-Hispanic Whites (adjusted OR 0.57, $9 5 \%$ CI 0.39–0.83), and women had lower odds than men (adjusted OR 0.60, $9 5 \%$ CI 0.45–0.80), with no improvement in diabetes treatment gaps from prior time periods (2005–2008 and 2009–2012), especially for minorities, women, and younger adults (227). Within insured settings, disparities have been reported among Blacks as compared with Whitesdin measures including dilated eye exam taken; LDL test taken; LDL, blood pressure, or $\mathsf { H b A } _ { 1 \mathrm { c } }$ control; and statin therapy (244–246). A study of 21 VA facilities found Blacks with diabetes were more likely than Whites with diabetes to receive care at lower-performing facilities overall, which explained some racial differences in diabetes quality measures (246).

# Health Care Interventions and Diabetes

Community Health Workers. Several systematic reviews have concluded that community health worker (CHW) interventions using trained lay workforces are effective for multiple outcomes in underserved African American and Hispanic adults with T2DM and comorbid conditions (247–250). CHWs have been integrated into care delivery (251,252) with reimbursement in some states (253). Roles of CHWs include patient navigation, appointment scheduling, visit attendance, patient education, home-based monitoring, assessment of social needs and connection with social services, social support, and advocacy (252,254). Reported outcomes include better diabetes knowledge and self-care behaviors, increased quality oflife, reduced emergency visits and hospitalizations, reduced costs, and modest improvements in glycemic control (247–250,255), using home-based or integrated health team delivery models (252,256). A majority of the CHW interventions designed for adult populations with diabetes have been diabetes-focused in content and goals and have utilized structured curricula (254); however, one series of studies reported use of a standardized, all-condition CHW intervention and found modest gain in diabetes outcomes along with additional health benefits (257,258).

Organizational Interventions. Systematic reviews report improvements in quality of diabetes care among racial/ethnic minorities resulting from quality improvement employing health information technology (i.e., patient registries in the electronic health record, computerized decision support for providers, reminders, centralized outreach for diabetes patients overdue for specific services) (245,259,260). There is also evidence of effectiveness of self-management interventions delivered directly to underserved patients with diabetes when interventions are designed to overcome barriers. For example, the Centers for Medicare & Medicaid Services (CMS)- sponsored National Diabetes Prevention Program (DPP) Medicaid demonstration found CDC-recognized DPP lifestyle change programs were effective in achieving performance measures among Medicaid recipients in Maryland and Oregon, and additional strategies (i.e., transportation assistance and child care) facilitated the highretention reportedover the12months of DPP visits (261). In a series of studies, a problem-based self-management training addressing multiple life barriers to care in low-income and minority populations was adapted for low literacy and prevalent diabetes-related functional limitations (e.g., low vision, physical disability, and mild cognitive impairment) that impede self-management education (73,262). The approach has proven effective in improvingclinicaloutcomes $\mathtt { H b A } _ { 1 \mathtt { c } }$ bloodpressure), self-care behaviors, and self-management knowledge and problem-solving skills in low-income, racial/ethnic minority, and rural populations (76,263,264).

Policy. Studies have examined the impact of the Affordable Care Act (ACA) on insurance coverage and health care access for patients with diabetes (265). Analyses of NHIS data from 2009 and 2016 found an increase nationwide of 770,000 more adults with diabetes aged 18 to 64 years with health insurance coverage in 2016, with a significant increase in coverage seen among Whites, Blacks, and Hispanics, people with family income $< \$ 35,000$ , and people across educational attainment strata (less than high school and more than high school) (266). Among people with diabetes in the lowest income strata, the proportion of income spent on health costs decreased significantly from $6 . 3 \%$ to $4 . 8 \%$ (266). Other studies found increased access to care, diabetes management, and health status among people with diabetes in Medicaid expansion states as compared with their counterparts in non–Medicaid expansion states (267); increased rates of diabetes detection and diagnosis among Medicaid patients with undiagnosed diabetes in states with Medicaid expansion (268); and reduction in costrelated medication nonadherence rates and uninsured rates among people with diabetes following ACA (269).

# Social Context and Diabetes

Several multidimensional factors shape the social environment as a determinant of health (270), including social capital, social cohesion, and social support (28,29). Social capital is defined as the features of social structures that serve as resources for collective action (e.g., interpersonal trust, reciprocity norms, and mutual aid) (271–273). Bonding social capital refers to trusting and co-operative relations between members of a network who see themselves as being similar in terms of their shared social identity; by contrast, bridging social capital refers to aspects of respect and mutuality between people who do not share social identities (e.g., differing by race/ethnicity, social class, age) (274–276). Racism, discrimination, and inclusion versus exclusion are macro-level social capital factors that impact health (28).

Social cohesion refers to the extent of connectednessand solidarityamonggroups in a community (271,277) and has two dimensions: reduction of inequalities and patterns of social exclusion of population subgroups from full participation in society (278) and strengthening of social relationships and interactions (279–281). Social cohesion actions facilitate the goal of keeping the society united, not only through social relations, community ties, and intergroup harmony but also through reducing bias and discrimination toward economically disadvantaged groups within a society, such as women and ethnic minorities (28).

Social support describes experiences in individuals’ formal and informal personal relationships as well as their perceptions of those relationships. Categories include emotional support, tangible support, informational support, and companionship (282–285). Social support is theorized to operate by either buffering the effects of poor health or by directly impacting health (285,286).

# Associations of Social Context With Diabetes Incidence, Prevalence, and Outcomes

A systematic review by Flor et al. (287) ˆ concluded that social capital was positively associated with diabetes control among different populations, independent of the quality or quantity of social capital. However, the few studies available and variations among populations and measures limit the ability to draw firm conclusions related to dimensions of social capital and whether the association is the same at the individual or neighborhood level (272,288–290). Gebreab et al. (189), using data from the Jackson Heart Study, examined social cohesion, measured as trust in neighbors, shared values with neighbors, willingness to help neighbors, and extent to which neighbors get along. The study revealed higher neighborhood social cohesion was associated with a $2 2 \%$ lower incidence of T2DM (189). Studies demonstrating the relationship between social support and diabetes have associated increased social support with better glycemic control and improved quality of life (291–295), while lack of social support has been associated with increased mortality and diabetes-related complications (291).

A number of studies suggest social cohesion, social capital, and social support may influencedor be influenced bydracism and discrimination (296). Racism interacts with other social entities, creating a set of dynamic, interdependent components that reinforce each other, sustaining racial inequities and promoting both institutional- and individuallevel discrimination across various sectors of society impacting diabetes incidence (296,297). For example, Whitaker et al. (298) documented associations of major and everyday discrimination experiences with incident diabetes among a diverse sample of 5,310 middle-aged to older adults from the Multi-Ethnic Study of Atherosclerosis. The Black Women’s Health Study found that, when compared with women in the lowest quartile of exposure, those in the highest quartile of exposure to everyday racism had a $31 \%$ increased risk of diabetes (HR 1.31, $9 5 \%$ CI 1.20–1.42), and women with the highest exposure to lifetime racism had a $1 6 \%$ increased risk (HR 1.16, $9 5 \%$ CI 1.05– 1.27); both associations were mediated by BMI (298,299). Further work is needed to understand the multiple ways that the social environment influences inequities in diabetes outcomes.

# Social Context Interventions and Diabetes Outcomes

To our knowledge, there is no empirical research on social capital or social cohesion interventions and impact on diabetes outcomes, but a body of literature has examined effects of social support. The systematic review by Strom and Egede (284) of 18 observational studies of adults with T2DM found that higher levels of social support were associated with outcomes including better glycemic control, knowledge, treatment adherence, quality of life, diagnosis awareness and acceptance, and stress reduction (284). Lack of social support has been linked with increased mortality and diabetes-related complications in T2DM (291,295). Strom and Egede’s review of 16 social support intervention studies demonstrated improved diabetes-related outcomes (clinical, psychosocial, and/or self-management behavior change) in adults with T2DM, and improvements in clinical outcomes $( \mathsf { H b A } _ { 1 \mathsf { c } } ,$ blood pressure, lipids) appeared to be unrelated to the source or delivery (i.e., peer support, couples/spouse, or nurse manager).

With regard to preferencesdin a study conducted before the coronavirus disease 2019 pandemicdSarkar et al. (300) found that, compared with White adults with diabetes, Hispanics with diabetes preferred telephone-based and group support (including promotoras), while African Americans demonstrated more variability in their preferences (i.e., telephone, group, internet). Reliance on support from family and community tended to be higher in minority populations, while Whites relied more on media and health care professionals (300).

# LINKAGES ACROSS HEALTH CARE AND COMMUNITY SECTORS TO ADDRESS SDOH

International and U.S. national committees have convened to provide guidance on SDOH intervention approaches. These expert committee recommendations are not specific to any disease; rather, they are applicable to all conditions and populations of health inequity. Table 3 displays recommendations from the WHO Commission on Social Determinants of Health (27), the National Academies of Sciences, Engineering, and Medicine (NASEM) (formerly, Institute of Medicine) Committee on the Recommended Social and Behavioral Domains and Measures for Electronic Health Records (80), the NASEM Committee on Educating Health Professionals to Address the Social Determinants of Health (301), and the NASEM Committee on Integrating Social Needs Care into the Delivery of Health Care to Improve the Nation’s Health (5).

The WHO recommendations are unique in their emphasis on root-cause, multisector interventions designed to remove the SDOH as a barrier to health equity. The NASEM recommendations are based in the health care sector and, collectively, focus on integration of SDOH into the health care mission, operations, and financial model. Accountable care organizations, value-based purchasing, and shared savings programs could be intentionally designed to support and incentivize health care systems to address patients’ health-related social needs as a strategy to improve health outcomes (5). The Accountable Health Communities is one current CMS demonstration project examining impact on health care costs of three models for health care response to SDOH through linkages with community services: awareness (screening for social needs within the health care setting and patient referral to services using an inventory of available local community services), assistance (screening, referral, plus navigation to enable access to and use of communityservices),andalignment(screening, referral, community service navigation, plus partner alignment using a “backbone” organization for capacity building, data sharing among community and health care partners, and scaling of services) (302). Many health care systems are utilizing electronic medical records and health information exchanges to capture SDOH data and commercially available SDOH algorithms to identify patients at social risk and trigger service referrals (303). NASEM provided assessment questions to capture SDOH domains and frequencies for assessment (304) with evidence of feasibility (305). In addition, Table 4 displays publicly available resources and tools to aid providers in addressing individual patients’ social needs.

# DISCUSSION

There is SDOH evidence supporting associations of SES, neighborhood and physical environment, food environment, health care, and social context with diabetes-related outcomes. Inequities in living and working conditions and the environments in which people reside have a direct impact on biological and behavioral outcomes associated with diabetes prevention and control (12,48). Life-course exposure based on the length of time one spends living in resourcedeprived environmentsddefined by poverty, lack of quality education, or lack of health caredsignificantly impacts disparities in diabetes risk, diagnosis, and outcomes (12,48,306). Although the review reports SDOH intervention studies for aspects of housing, built and food environment, and health care, there appears to be relatively limited U.S.-based research examining impact on diabetes of interventions designed to target education, income, occupation, toxic environmental exposures, social cohesion, and social capital.

In the U.S., integrating social context into health care delivery has become a priority strategy (5–8). A clinical context alone, however, is too narrow to accommodate systemic SDOH influences. Structural and legal interventions are needed to address root causes driving SDOH (27,307). Similarly, additional emphasis is needed on a next generation of research that prioritizes interventions impacting the root causes of diabetes inequities, rather than compensatory interventions assisting the individual to adapt to inequities (18,308). For example, in the U.S., proficient literacy and resulting health literacy are disproportionately low in marginalized populations and communities (42), with historical sociopolitical root causes. U.S. antiliteracy laws for Blacks, which prohibited Blacks from being taught to read or write, persisted until the 1930s in some states (309,310), and laws prohibiting African Americans from attending public and private schools Whites attended continued until 1954 and 1976, respectively (311). Although adapting health materials for low-literacy suitability is an effective intervention to compensate for centuries of legal racial discrimination in educational access and quality, a nextgeneration intervention might target the education sector and implement delivery of high-quality early education to all within both the public and private school systems and with equitable educational funding for sociodemographic populations. Similarly, while partnerships to bring bags of healthy groceries to low-income families living in food deserts are important to compensate for food deserts, a next-generation approach might target historical redlining and zoning policies that are the root cause of absence of supermarkets and fresh food markets in minority and lowerincome neighborhoods (312–314).

The review has limitations. First, the undertaking was designed to summarize literature on the range of SDOH identified as having impact on diabetes outcomes. As such, this article describes findings from systematic reviews and meta-analyses as well as more recent published studies on the named SDOH; it was not designed as a primary systematic review of all published research on the topic. Second are limitations of the research itself, including wide variability in measures and definitions used in studies within an SDOH area, making it more difficult to describe outcomes for an SDOH area in a consistent or uniform manner or to report quantitative outcomes derived from meta-analyses. Third, this review was U.S.-focused; conclusions from SDOH research in other countries, which in some instances may utilize more standardly defined SDOH variables (e.g., occupation) are not part of this initial review. Finally, the many complexities ofSDOHand their potentially different pathways and impacts on populations are beyond the scope of this initial review and require attention to specificity in designs of future SDOH research in diabetes.

Recommendations for SDOH research in diabetes resulting from this SDOH review are described in Table 5 and include establishing consensus SDOH definitions and metrics, designing studies to examine specificities based on populations, prioritizing next-generation interventions, embedding SDOH context within dissemination and implementation science in diabetes, and training researchers in methodological techniques for future SDOH intervention studies. By addressing these critical elements, there is potential for progress to be realized in achieving greater health equity in diabetes and across health outcomes that are socially determined.

Acknowledgments. The authors express appreciation to Malaika I. Hill and Mindy Saraco of the American Diabetes Association; Elizabeth A. Vrany, Johns Hopkins University School of Medicine; and Shelly Johnson, Washington University in St. Louis, for providing technical assistance for this review. Funding. F.H.-B. is supported in part by the Johns Hopkins Institute for Clinical and Translational Research (ICTR), which is funded in part by grant UL1TR003098 from the National Center for Advancing Translational Sciences (NCATS), a component of the National Institutes of Health (NIH) and NIH Roadmap for Medical Research. F.H.-B. is also supported in part by NIH National Heart, Lung, and Blood Institute (NHLBI) grant T32HL07180. D.H.-J. is supported in part by NIH National Institute of Diabetes and Digestive and Kidney Diseases (NIDDK) grant P30DK092950. M.H.C. is supported in part by NIH and NIDDK grant P30DK092949. T.L.G.-W. is supported in part by NHLBI grant R01HL131531. A.N.-A. is supported in part by National Institute of Environmental Health Sciences grants P42ES010349 and P30ES009089. S.A.B. is supported in part by NIDDK grant K23DK109200.

The findings and conclusion in this report are those of the authors and do not necessarily represent the official position of the Johns Hopkins ICTR, NCATS, NIH, NIDDK, or any other institution mentioned in the article.

Duality of Interest. M.H.C. reports being cocoordinator of the “Bridging the Gap: Reducing Disparities in Diabetes Care National Program Office,” supported by the Merck Foundation, a consultant to the Patient-Centered Outcomes Group, and a member of the Bristol-Myers Squibb Company Health Equity Advisory Board. S.A.B. received personal fees for service on an advisory board about prioritizing food insecurity research topics for the Aspen Institute. T.L.G.-W. received personal fees for service on an advisory board about prioritizing food insecurity research topics for the Aspen Institute. No other potential conflicts of interests relevant to this article were reported. Author Contributions. F.H.-B. researched data and wrote the manuscript. N.E.A. contributed to writing and reviewing/editing the manuscript. S.A.B. researched data and contributed to writing and reviewing/editing the manuscript. M.H.C. contributed to writing and reviewing/editing the manuscript. T.L.G.-W. researched data and contributed to writing and reviewing/editing the manuscript. A.N.-A. researched data and contributed to writing the manuscript. P.L.T. researched data and contributed to writing and reviewing/editing the manuscript. D.H.-J. researched data and contributed to writing and reviewing/editing the manuscript.

# References

1. Golden SH, Brown A, Cauley JA, et al. Health disparities in endocrine disorders: biological, clinical, and nonclinical factorsdan Endocrine

Society scientific statement. J Clin Endocrinol Metab 2012;97:E1579–E1639

3. U.S. Department of Health and Human Services, Office of the Secretary, Office of the Assistant Secretary for Planning and Evaluation, and Office of Minority Health. HHS Action Plan to Reduce Racial and Ethnic Health Disparities: Implementation Progress Report 2011-2014. Washington, DC, Office of the Assistant Secretary for Planning and Evaluation, 2015   
4. Chin MH. Creating the business case for achieving health equity. J Gen Intern Med 2016;31:792–796 5. National Academies of Sciences, Engineering, and Medicine. Integrating Social Care Into the Delivery of Health Care: Moving Upstream to Improve the Nation’s Health. Washington, DC, National Academies Press, 2019   
6. Byhoff E, Kangovi S, Berkowitz SA, et al.; Society of General Internal Medicine. A Society of General Internal Medicine position statement on the internists’ role in social determinants of health. J Gen Intern Med 2020;35: 2721–2727   
7. Council on Community Pediatrics; Duffee JH, Kuo A, Gitterman BA. Poverty and child health in the United States. Pediatrics 2016;137:e20160339 8. Daniel H, Bornstein SS, Kane GC; Health and Public Policy Committee of the American College of Physicians. Addressing social determinants to improve patient care and promote health equity: an American College of Physicians position paper. Ann Intern Med 2018;168:577–578   
9. Peek ME, Vela MB, Chin MH. Practical lessons for teaching about race and racism: successfully leading free, frank, and fearless discussions. Acad Med. 1 September 2020 [Epub ahead of print]. DOI: 10.1097/ACM.0000000000003710   
10. Vela M, Blackman D, Burnet D, et al. Racialized violence and health care’s call to action, 6 June 2020. KevinMD.com. Accessed 7 June 2020. Available from https://www.kevinmd.com/blog/ 2020/06/racialized-violence-and-health-carescall-to-action.html   
11. Chin MH, King PT, Jones RG, et al. Lessons for achieving health equity comparing Aotearoa/ New Zealand and the United States. Health Policy 2018;122:837–853   
12. Haire-Joshu D, Hill-Briggs F. The next generation of diabetes translation: a path to health equity. Annu Rev Public Health 2019;40:391–410 13. Golden SH, Maruthur N, Mathioudakis N, et al. The case for diabetes population health improvement: evidence-based programming for population outcomes in diabetes. Curr Diab Rep 2017;17:51 14. Hill-Briggs F. 2018 Health Care & Education Presidential Address: the American Diabetes Association in the era of health care transformation. Diabetes Care 2019;42:352–358   
15. Hill JO, Galloway JM, Goley A, et al. Scientific statement: socioecological determinants of prediabetes and type 2 diabetes. Diabetes Care 2013;36:2430–2439   
16. U.S. Department of Health and Human Services. Section IV: Advisory Committee findings and recommendations. In The Secretary’s Advisory

2. Centers for Medicare & Medicaid Services, Office of Minority Health. The CMS Equity Plan for Improving Quality in Medicare, September 2015. Accessed 25 October 2020. Available from https://www.cms.gov/About-CMS/Agency-Information/ OMH/OMH_Dwnld-CMS_EquityPlanforMedicare_ 090615.pdf

Committee on National Health Promotion and Disease Prevention Objectives for 2020. Phase I report,2008. Accessed 25 October 2020. Available from http://www.healthypeople.gov/sites/ default/files/PhaseI_0.pdf

17. Dankwa-Mullan I, Rhee KB, Williams K, et al. The science of eliminating health disparities: summary and analysis of the NIH summit recommendations. Am J Public Health 2010;100(Suppl. 1):S12–S18   
18. Thornton PL, Kumanyika SK, Gregg EW, et al. New research directions on disparities in obesity and type 2 diabetes. Ann N Y Acad Sci 2020;1461:5–24 19. Institute of Medicine Committee on Understanding Eliminating Racial Ethnic Disparities in Health Care. Unequal Treatment: Confronting Racial and Ethnic Disparities in Health Care. Smedley BD, Stith AY, Nelson AR, Eds. Washington, DC, National Academies Press, 2003 20. Braveman P, Arkin E, Orleans T, Proctor D, Plough A. What Is Health Equity? And What Difference Does a Definition Make? Princeton, NJ, Robert Wood Johnson Foundation, 2017 21. U.S. Department of Health and Human Services. Healthy People 2020: An Opportunity to Address the Societal Determinants of Health in the United States. Secretary’s Advisory Committee on National Health Promotion and Disease Prevention Objectives for 2020, 26 July 2010. Accessed 25 October 2020. Available from http://www.healthypeople.gov/2010/hp2020/ advisory/SocietalDeterminantsHealth.htm   
22. Marmot M, Allen JJ. Social determinants of health equity. Am J Public Health 2014; 104(Suppl. 4):S517–S519   
23. U.S. Department of Health and Human Services, Office of Disease Prevention and Health Promotion. Foundation health measures: disparities. Accessed 25 October 2020. Available from https://www.healthypeople.gov/2020/about/ foundation-health-measures/Disparities   
24. World Health Organization. Health equity. Accessed 25 October 2020. Available from https://www.who.int/topics/health_equity/en/ 25. County Health Rankings & Roadmaps. Measures& data sources, 2019.Accessed2Februrary 2020. Available from https://www.countyhealthrankings .org/explore-health-rankings/measures-data-sources 26. World Health Organization. About social determinants of health, 2020. Accessed 7 February 2020. Available from https://www.who.int/ social_determinants/sdh_definition/en/   
27. Commission on the Social Determinants of Health. Closing the gap in a generation: health equity through action on the social determinants of health. Final report of the Commission on Social Determinants of Health. Geneva, World Health Organization, 2008. Accessed 25 October 2020. Available from https://www.who.int/social_determinants/ final_report/csdh_finalreport_2008.pdf   
28. Solar O, Irwin A. A conceptual framework for action on the social determinants of health. Social Determinants of Health Discussion Paper 2 (Policy and Practice). Geneva, World Health Organization, 2010. Accessed 25 October 2020. Available from https://www.who.int/sdhconference/ resources/ConceptualframeworkforactiononSDH_ eng.pdf   
29. U.S. Department of Health and Human Serv

ices, Office of Disease Prevention and Health Promotion. Healthy people 2020: social determinants of health. Accessed 25 October 2020. Available

30. Centers for Disease Control and Prevention. About social determinants of health (SDOH). Accessed 14 August 2020. Available from https:// www.cdc.gov/socialdeterminants/about.html. 31. Remington PL, Catlin BB, Gennuso KP. The County Health Rankings: rationale and methods. Popul Health Metr 2015;13:11   
32. County Health Rankings & Roadmaps. County Health Rankings Model, 2014. Accessed 25 October 2020. Available from https:// www.countyhealthrankings.org/resources/countyhealth-rankings-model   
33. Artiga S, Hinton E. Beyond health care: the role of social determinants in promoting health and health equity. Issue Brief, May 2018. Kaiser Family Foundation. Accessed 25 October 2020. Available from http://files.kff.org/attachment/ issue-brief-beyond-health-care   
34. Saegert SC, Adler NA, Bullock HE, Cauce AM, Liu WM, Wyche KF. Report of the American Psychological Association Task Force on Socioeconomic Status. Washington, DC, American Psychological Association, 2007   
35. Dutton DB, Levine S. Socioeconomic status and health: overview, methodological critique, and reformulation. In Pathways to Health: The Role of Social Factors. Bunker P, Gomby DS, Kehrer BH, Eds. Menlo Park, CA, The Henry J. Kaiser Family Foundation, 1989, pp. 29–69   
36. Adler NE, Boyce T, Chesney MA, et al. Socioeconomic status and health. The challenge of the gradient. Am Psychol 1994;49: 15–24   
37. Adler NE, Newman K. Socioeconomic disparities in health: pathways and policies. Health Aff (Millwood) 2002;21:60–76   
38. Braveman PA, Cubbin C, Egerter $\mathsf { S } ,$ et al. Socioeconomic status in health research: one size does not fit all. JAMA 2005;294:2879–2888 39. Shavers VL. Measurement of socioeconomic status in health disparities research. J Natl Med Assoc 2007;99:1013–1023   
40. Dotson VM, Kitner-Triolo MH, Evans MK, Zonderman AB. Effects of race and socioeconomic status on the relative influence of education and literacy on cognitive functioning. J Int Neuropsychol Soc 2009;15:580–589   
41. Sisco S, Gross AL, Shih RA, et al. The role of early-life educational quality and literacy in explaining racial disparities in cognition in late life. J Gerontol B Psychol Sci Soc Sci 2015;70:557–567 42. Rudd RE. Health literacy skills of U.S. adults. Am J Health Behav 2007;31(Suppl. 1):S8–S18 43. Kutner M, Greenberg E, Jin Y, Boyle B, Hsu Y, Dunleavy E (Eds.). Literacy in Everyday Life: Results From the 2003 National Assessment of Adult Literacy (NCES 2007–480). Washington, DC, National Center for Education Statistics, 2007 44. Kutner M, Greenburg E, Jin Y, Paulsen C. The Health Literacy of America’s Adults: Results From the 2003 National Assessment of Adult Literacy (NCES 2006-483). Washington, DC, National Center for Education Statistics, 2006   
45. Gornick ME. 2. Measuring the effects of socioeconomic status on health care. In Guidance for the National Healthcare Disparities Report. Swift EK, Ed. Washington, DC, National Academies Press, 2002

46. Agardh E, Allebeck P, Hallqvist J, Moradi T, Sidorchuk A. Type 2 diabetes incidence and socio-economic position: a systematic review and meta-analysis. Int J Epidemiol 2011;40:804– 818

47. Brown AF, Ettner SL, Piette J, et al. Socioeconomic position and health among persons with diabetes mellitus: a conceptual framework and review of the literature. Epidemiol Rev 2004; 26:63–77   
48. Braveman PA, Cubbin C, Egerter S, Williams DR, Pamuk E. Socioeconomic disparities in health in the United States: what the patterns tell us. Am J Public Health 2010;100(Suppl. 1):S186–S196 49. Gaskin DJ, Thorpe RJ Jr, McGinty EE, et al. Disparities in diabetes: the nexus of race, poverty, and place. Am J Public Health 2014;104: 2147–2155   
50. Beckles GL, Chou CF. Disparities in the prevalence of diagnosed diabetes – United States, 1999-2002 and 2011-2014. MMWR Morb Mortal Wkly Rep 2016;65:1265–1269   
51. Drewnowski A, Rehm CD, Moudon AV, Arterburn D. The geography of diabetes by census tract in a large sample of insured adults in King County, Washington, 2005-2006. Prev Chronic Dis 2014;11:E125   
52. Kolak M, Abraham G, Talen MR. Mapping census tract clusters of type 2 diabetes in a primary care population. Prev Chronic Dis 2019; 16:E59   
53. Schmittdiel JA, Dyer WT, Marshall CJ, Bivins R. Using neighborhood-level census data to predict diabetes progression in patients with laboratory-defined prediabetes. Perm J 2018; 22:18–096   
54. Saydah S, Lochner K. Socioeconomic status and risk of diabetes-related mortality in the U.S. Public Health Rep 2010;125:377–388   
55. Scott A, Chambers D, Goyder E, O’Cathain A. Socioeconomic inequalities in mortality, morbidity and diabetes management for adults with type 1 diabetes: a systematic review. PLoS One 2017;12: e0177210   
56. Bijlsma-Rutte A, Rutters F, Elders PJM, Bot SDM, Nijpels G. Socio-economic status and $\mathsf { H b A } _ { 1 \mathsf { c } }$ in type 2 diabetes: a systematic review and metaanalysis. Diabetes Metab Res Rev 2018;34:e3008 57. Lindner LME, Rathmann W, Rosenbauer J. Inequalities in glycaemic control, hypoglycaemia and diabetic ketoacidosis according to socioeconomic status and area-level deprivation in type 1 diabetes mellitus: a systematic review. Diabet Med 2018;35:12–32   
58. Borschuk AP, Everhart RS. Health disparities among youth with type 1 diabetes: a systematic review of the current literature. Fam Syst Health 2015;33:297–313   
59. Walker RJ, Garacci E, Palatnik A, Ozieh MN, Egede LE. The longitudinal influence of social determinants of health on glycemic control in elderly adults with diabetes. Diabetes Care 2020; 43:759–766   
60. Centers for Disease Control and Prevention. National Diabetes Statistics Report, 2017. Atlanta, GA, Centers for Disease Control and Prevention, US Department of Health and Human Services, 2017. Accessed 25 October 2020. Available from https://dev.diabetes.org/sites/default/ files/2019-06/cdc-statistics-report-2017.pdf   
61. Centers for Disease Contol and Prevention. Diabetes Report Card 2017. Atlanta, GA, Centers 62. Borrell LN, Dallo FJ, White K. Education and diabetes in a racially and ethnically diverse population. Am J Public Health 2006;96:1637–1642 63. Secrest AM, Costacou T, Gutelius B, Miller RG, Songer TJ, Orchard TJ. Association of socioeconomic status with mortality in type 1 diabetes: the Pittsburgh Epidemiology of Diabetes Complications Study. Ann Epidemiol 2011;21: 367–373   
64. Marciano L, Camerini AL, Schulz PJ. The role of health literacy in diabetes knowledge, selfcare, and glycemic control: a meta-analysis. J Gen Intern Med 2019;34:1007–1017   
65. Ferrie JE, Virtanen M, Jokela M, et al.; IPDWork Consortium. Job insecurity and risk of diabetes: a meta-analysis of individual participant data. CMAJ 2016;188:E447–E455   
66. Varanka-Ruuska T, Rautio N, Lehtiniemi H, et al. The association of unemployment with glucose metabolism: a systematic review and meta-analysis. Int J Public Health 2018;63:435– 446   
67. Gan Y, Yang C, Tong X, et al. Shift work and diabetes mellitus: a meta-analysis of observational studies. Occup Environ Med 2015;72:72– 78   
68. Kivimaki M, Virtanen M, Kawachi I, et al. Long working hours, socioeconomic status, and the risk of incident type 2 diabetes: a meta-analysis of published and unpublished data from 222 120 individuals. Lancet Diabetes Endocrinol 2015;3: 27–34   
69. Gallup-Sharecare. The Face of Diabetes in the United States, State of American Well-being, 2017. Accessed 25 October 2020. Available from https://wellbeingindex.sharecare.com/wp-content/ uploads/2017/12/The-Face-of-Diabetes-in-the-UnitedStates-2017.pdf   
70. Witters D, Liu D. Diabetes rate greatest among transportation workers. Gallup, Inc., 2017. Accessed 25 October 2020. Available from https://news.gallup.com/poll/214097/ diabetes-rate-greatest-among-transportationworkers.aspx   
71. Hill-Briggs F, Schumann KP, Dike O. Five-step methodology for evaluation and adaptation of print patient health information to meet the $<$ 5th grade readability criterion. Med Care 2012; 50:294–301   
72. Cavanaugh KL. Health literacy in diabetes care: explanation, evidence and equipment. Diabetes Manag (Lond) 2011;1:191–199   
73. Hill-Briggs F, Renosky R, Lazo M, et al. Development and pilot evaluation of literacy-adapted diabetes and CVD education in urban, diabetic African Americans. J Gen Intern Med 2008;23: 1491–1494   
74. White RO, Eden S, Wallston KA, et al. Health communication, self-care, and treatment satisfaction among low-income diabetes patients in a public health setting. Patient Educ Couns 2015; 98:144–149   
75. Kim SH, Lee A. Health-literacy-sensitive diabetes self-management interventions: a systematic review and meta-analysis. Worldviews Evid Based Nurs 2016;13:324–333

for Disease Control and Prevention, US Department of Health and Human Services, 2018. Accessed 25 October 2020. Available from https://www.cdc .gov/diabetes/pdfs/library/diabetesreportcard2017- 508.pdf

77. Cavanaugh K, Wallston KA, Gebretsadik T, et al. Addressing literacy and numeracy to improve diabetes care: two randomized controlled trials. Diabetes Care 2009;32:2149–2155   
78. Diez Roux AV, Mair C. Neighborhoods and health. Ann N Y Acad Sci 2010;1186:125–145 79. Tung EL, Cagney KA, Peek ME, Chin MH. Spatial context and health inequity: reconfiguring race, place, and poverty. J Urban Health 2017; 94:757–763   
80. Institute of Medicine. Capturing Social and Behavioral Domains and Measures in Electronic Health Records: Phase 2. Washington, DC, The National Academies Press, 2014   
81. Baggett TP, Berkowitz SA, Fung V, Gaeta JM. Prevalence of housing problems among community health center patients. JAMA 2018;319:717– 719   
82. Berkowitz SA, Kalkhoran S, Edwards ST, Essien UR, Baggett TP. Unstable housing and diabetes-related emergency department visits and hospitalization: a nationally representative study of safety-net clinic patients. Diabetes Care 2018;41:933–939   
83. Kushel MB, Gupta R, Gee L, Haas JS. Housing instability and food insecurity as barriers to health care among low-income Americans. J Gen Intern Med 2006;21:71–77   
84. Vijayaraghavan M, Jacobs EA, Seligman H, Fernandez A. The association between housing instability, food insecurity, and diabetes selfefficacy in low-income adults. J Health Care Poor Underserved 2011;22:1279–1291   
85. Children’s Health Watch. Our survey. Accessed 25 October 2020. Available from https:// childrenshealthwatch.org/methods/our-survey/ 86. U.S. Congress. H.R.558 - Stewart B. McKinney homeless assistance act, 1987. Accessed 25 October 2020. Available from https://www .congress.gov/bill/100th-congress/house-bill/558 87. Henry M, Watt R, Mahathey A, Ouellette J, Sitler A; Abt Associates. The 2019 Annual Homeless Assessment Report (AHAR) to Congress; Part 1: Point-in-Time Estimates of Homelessness, January 2020. U.S. Department of Housing and Urban Development. Accessed 25 October 2020. Available from https://www.hudexchange.info/ resource/5948/2019-ahar-part-1-pit-estimatesof-homelessness-in-the-us/   
88. Cutts DB, Meyers AF, Black MM, et al. US Housing insecurity and the health of very young children. Am J Public Health 2011;101:1508–1514 89. Frederick TJ, Chwalek M, Hughes J, Karabanow J, Kidd S. How stable is stable? Defining and measuring housing stability. J Community Psychol 2014;42:964–979   
90. Meltzer R, Schwartz A. Housing affordability and health: evidence from New York City. Hous Policy Debate 2016;26:80–104   
91. Keene DE, Guo M, Murillo S. “That wasn’t really a place to worry about diabetes”: housing access and diabetes self-management among low-income adults. Soc Sci Med 2018;197:71–77 92. Quensell ML, Taira DA, Seto TB, Braun KL, Sentell TL. “I need my own place to get better”: patient perspectives on the role of housing in potentially preventable hospitalizations. J Health Care Poor Underserved 2017;28:784–797

76. Hill-Briggs F, Lazo M, Peyrot M, et al. Effect of problem-solving-based diabetes self-management training on diabetes control in a low income patient sample. J Gen Intern Med 2011;26:972–978

94. Bernstein RS, Meurer LN, Plumb EJ, Jackson JL. Diabetes and hypertension prevalence in homeless adults in the United States: a systematic review and meta-analysis. Am J Public Health 2015;105:e46–e60   
95. Berkowitz SA, Meigs JB, DeWalt D, et al. Material need insecurities, control of diabetes mellitus, and use of health care resources: results of the Measuring Economic Insecurity in Diabetes study. JAMA Intern Med 2015;175: 257–265   
96. Burgard SA, Seefeldt KS, Zelner S. Housing instability and health: findings from the Michigan Recession and Recovery Study. Soc Sci Med 2012; 75:2215–2224   
97. Charkhchi P, Fazeli Dehkordy S, Carlos RC. Housing and food insecurity, care access, and health status among the chronically ill: an analysis of the Behavioral Risk Factor Surveillance System. J Gen Intern Med 2018;33:644–650 98. Stahre M, VanEenwyk J, Siegel P, Njai R. Housing insecurity and the association with health outcomes and unhealthy behaviors, Washington State, 2011. Prev Chronic Dis 2015;12:140511   
99. Gibson M, Petticrew M, Bambra C, Sowden AJ, Wright KE, Whitehead M. Housing and health inequalities: a synthesis of systematic reviews of interventions aimed at different pathways linking housing and health. Health Place 2011;17: 175–184   
100. Shaw M. Housing and public health. Annu Rev Public Health 2004;25:397–418   
101. Brooks LK, Kalyanaraman N, Malek R. Diabetes care for patients experiencing homelessness: beyond metformin and sulfonylureas. Am J Med 2019;132:408–412   
102. Ludwig J, Sanbonmatsu L, Gennetian L, et al. Neighborhoods, obesity, and diabetesda randomized social experiment. N Engl J Med 2011;365:1509–1519   
103. Orr L, Feins JD, Jacob R, et al. Moving to Opportunity for Fair Housing Demonstration Program: Interim Impacts Evaluation. Washington, DC, U.S. Department of Housing and Urban Development Office of Policy Development and Research, 2003. Accessed 25 October 2020. Available from https://www.huduser.gov/Publications/ pdf/MTOFullReport.pdf   
104. Sanbonmatsu L, Marvokov J, Porter N, et al. The long-term effects of Moving to Opportunity on adult health and economic self-sufficiency. Cityscape2012;14:109–136   
105. Baxter AJ, Tweed EJ, Katikireddi SV, Thomson H. Effects of Housing First approaches on health and well-being of adults who are homeless or at risk of homelessness: systematic review and meta-analysis of randomised controlled trials. J Epidemiol Community Health 2019;73:379–387   
106. Tsai J, Gelberg L, Rosenheck RA. Changes in physical health after supported housing: results from the Collaborative Initiative to End Chronic Homelessness. J Gen Intern Med 2019;34:1703– 1708   
107. Lim S, Miller-Archie SA, Singh TP, Wu WY, Walters SC, Gould LH. Supportive housing and its

93. Gelberg L, Andersen RM, Leake BD. The Behavioral Model for Vulnerable Populations: application to medical care use and outcomes for homeless people. Health Serv Res 2000;34:1273– 1302

‘Then I found housing and everything changed’: transitions to rent-assisted housing and diabetes self-management. Cityscape 2018;20:107– 118   
109. Centers for Disease Control and Prevention. Built environment assessment tool manual, 2019. Accessed 9 March 2020. Available from https://www.cdc.gov/nccdphp/dnpao/statelocal-programs/built-environment-assessment/ index.htm   
110. Drewnowski A, Buszkiewicz J, Aggarwal A, Rose C, Gupta S, Bradshaw A. Obesity and the built environment: a reappraisal. Obesity (Silver Spring) 2020;28:22–30   
111. Martin A, Ogilvie D, Suhrcke M. Evaluating causal relationships between urban built environment characteristics and obesity: a methodological review of observational studies. Int J Behav Nutr Phys Act 2014;11:142   
112. Mayne ${ \mathsf { S L } } ,$ Auchincloss AH, Michael YL. Impact of policy and built environment changes on obesity-related outcomes: a systematic review of naturally occurring experiments. Obes Rev 2015;16:362–375   
113. Chandrabose M, Rachele JN, Gunn L, et al. Built environment and cardio-metabolic health: systematic review and meta-analysis of longitudinal studies. Obes Rev 2019;20: 41–54   
114. Smalls BL, Gregory CM, Zoller JS, Egede LE. Assessing the relationship between neighborhood factors and diabetes related health outcomes and self-care behaviors. BMC Health Serv Res 2015;15:445   
115. Bilal U, Auchincloss AH, Diez-Roux AV. Neighborhood environments and diabetes risk and control. Curr Diab Rep 2018;18:62   
116. Leal C, Chaix B. The influence of geographic life environments on cardiometabolic risk factors: a systematic review, a methodological assessment and a research agenda. Obes Rev 2011;12:217–230   
117. Twohig-Bennett C, Jones A. The health benefits of the great outdoors: a systematic review and meta-analysis of greenspace exposure and health outcomes. Environ Res 2018;166: 628–637   
118. Durand CP, Andalib M, Dunton GF, Wolch J, Pentz MA. A systematic review of built environment factors related to physical activity and obesity risk: implications for smart growth urban planning. Obes Rev 2011;12:e173–e182   
119. Petticrew M, Cummins S, Ferrell C, et al. Natural experiments: an underused tool for public health? Public Health 2005;119:751–757 120. MacMillan F, George ES, Feng X, et al. Do natural experiments of changes in neighborhood built environment impact physical activity and diet? a systematic review. Int J Environ Res Public Health 2018;15:217   
121. Benton JS, Anderson J, Hunter RF, French DP. The effect of changing the built environment on physical activity: a quantitative review of the risk of bias in natural experiments. Int J Behav Nutr Phys Act 2016;13:107   
122. Amuda AT, Berkowitz SA. Diabetes and the built environment: evidence and policies. Curr Diab Rep 2019;19:35 124. Casey JA, Morello-Frosch R, Mennitt DJ, Fristrup K, Ogburn EL, James P. Race/ethnicity, socioeconomic status, residential segregation, and spatial variation in noise exposure in the contiguous United States. Environ Health Perspect 2017;125:077017   
125. Evans GW, Kantrowitz E. Socioeconomic status and health: the potential role of environmental risk exposure. Annu Rev Public Health 2002;23:303–331   
126. Hajat A, Hsia C, O’Neill MS. Socioeconomic disparities and air pollution exposure: a global review. Curr Environ Health Rep 2015;2:440– 450   
127. Miao $\mathbb { Q } ,$ Chen D, Buzzelli M, Aronson KJ. Environmental equity research: review with focus on outdoor air pollution research methods and analytic tools. Arch Environ Occup Health 2015;70:47–55   
128. Mohai P, Lantz PM, Morenoff J, House JS, Mero RP. Racial and socioeconomic disparities in residential proximity to polluting industrial facilities: evidence from the Americans’ Changing Lives Study. Am J Public Health 2009;99(Suppl. 3): S649–S656   
129. Perez AC, Grafton B, Mohai P, Hardin R, Hintzen K, Orvis S. Evolution of the environmental justice movement: activism, formalization and differentiation. Environ Res Lett 2015; 10:105002   
130. Tessum CW, Apte JS, Goodkind AL, et al. Inequity in consumption of goods and services adds to racial-ethnic disparities in air pollution exposure. Proc Natl Acad Sci U S A 2019;116: 6001–6006   
131. Apelberg BJ, Buckley TJ, White RH. Socioeconomic and racial disparities in cancer risk from air toxics in Maryland. Environ Health Perspect 2005;113:693–699   
132. Hilpert M, Johnson M, Kioumourtzoglou MA, et al. A new approach for inferring trafficrelated air pollution: use of radar-calibrated crowd-sourced traffic data. Environ Int 2019; 127:142–159   
133. Jones MR, Diez-Roux AV, Hajat A, et al. Race/ethnicity, residential segregation, and exposure to ambient air pollution: the Multi-Ethnic Study of Atherosclerosis (MESA). Am J Public Health 2014;104:2130–2137   
134. Bellavia A, Zota AR, Valeri L, James-Todd T. Multiple mediators approach to study environmental chemicals as determinants of health disparities. Environ Epidemiol 2018;2:e015 135. Dodd-Butera T, Beaman M, Brash M. Environmental health equity: a concept analysis. Annu Rev Nurs Res 2019;38:183–202   
136. Gee GC, Payne-Sturges DC. Environmental health disparities: a framework integrating psychosocial and environmental concepts. Environ Health Perspect 2004;112:1645–1653   
137. Krometis LA, Gohlke J, Kolivras K, Satterwhite E, Marmagas SW, Marr LC. Environmental health disparities in the Central Appalachian region of the United States. Rev Environ Health 2017;32: 253–266   
138. Lewis J, Hoover J, MacKenzie D. Mining and environmental health disparities in Native American communities. Curr Environ Health Rep 2017; 4:130–141

123. Landrigan PJ, Fuller R, Acosta NJR, et al. The Lancet Commission on pollution and health. Lancet 2018;391:462–512

140. Fox MA, Nachman KE, Anderson B, Lam J, Resnick B. Meeting the public health challenge of protecting private wells: proceedings and recommendations from an expert panel workshop. Sci Total Environ 2016;554-555:113–118   
141. Lee D, Murphy HM. Private wells and rural health: groundwater contaminants of emerging concern. Curr Environ Health Rep 2020;7:129– 139   
142. Groh KJ, Backhaus T, Carney-Almroth B, et al. Overview of known plastic packagingassociated chemicals and their hazards. Sci Total Environ 2019;651:3253–3268   
143. Nguyen VK, Kahana A, Heidt J, et al. A comprehensive analysis of racial disparities in chemical biomarker concentrations in United States women, 1999-2014. Environ Int 2020; 137:105496   
144. Varshavsky JR, Morello-Frosch R, Woodruff TJ, Zota AR. Dietary sources of cumulative phthalates exposure among the U.S. general population in NHANES 2005-2014. Environ Int 2018;115: 417–429   
145. Zota AR, Phillips CA, Mitro SD. Recent fast food consumption and bisphenol a and phthalates exposures among the U.S. population in NHANES, 2003-2010. Environ Health Perspect 2016;124:1521–1528   
146. Hartle JC, Navas-Acien A, Lawrence RS. The consumption of canned food and beverages and urinary Bisphenol A concentrations in NHANES 2003-2008. Environ Res 2016;150:375–382 147. Zota AR, Shamasunder B. The environmental injustice of beauty: framing chemical exposures from beauty products as a health disparities concern. Am J Obstet Gynecol 2017; 217:418.e1–418.e6   
148. Kuo CC, Moon K, Thayer KA, Navas-Acien A. Environmental chemicals and type 2 diabetes: an updated systematic review of the epidemiologic evidence. Curr Diab Rep 2013;13:831–849 149. Maull EA, Ahsan H, Edwards J, et al. Evaluation of the association between arsenic and diabetes: a National Toxicology Program workshop review. Environ Health Perspect 2012;120: 1658–1670   
150. Thayer KA, Heindel JJ, Bucher JR, Gallo MA. Role of environmental chemicals in diabetes and obesity: a National Toxicology Program workshop review. Environ Health Perspect 2012;120: 779–789   
151. Song Y, Chou EL, Baecker A, et al. Endocrinedisrupting chemicals, risk of type 2 diabetes, and diabetes-related metabolic traits: a systematic review and meta-analysis. J Diabetes 2016;8: 516–532   
152. Evangelou E, Ntritsos G, Chondrogiorgi M, et al. Exposure to pesticides and diabetes: a systematic review and meta-analysis. Environ Int 2016;91:60–68   
153. Jaacks LM, Staimez LR. Association of persistent organic pollutants and non-persistent pesticides with diabetes and diabetes-related health outcomes in Asia: a systematic review. Environ Int 2015;76:57–70   
154. Radke EG, Galizia A, Thayer KA, Cooper GS. Phthalate exposure and metabolic effects:

139. Powers M, Yracheta J, Harvey D, et al. Arsenic in groundwater in private wells in rural North Dakota and South Dakota: water quality assessment for an intervention trial. Environ Res 2019;168:41–47

meta-analysis. Environ Res 2020;180:108817 156. Eze IC, Hemkens LG, Bucher HC, et al. Association between ambient air pollution and diabetes mellitus in Europe and North America: systematic review and meta-analysis. Environ Health Perspect 2015;123:381–389   
157. Janghorbani M, Momeni F, Mansourian M. Systematic review and metaanalysis of air pollution exposure and risk of diabetes. Eur J Epidemiol 2014;29:231–242   
158. Liu F, Chen G, Huo W, et al. Associations between long-term exposure to ambient air pollution and risk of type 2 diabetes mellitus: a systematic review and meta-analysis. Environ Pollut 2019;252(Pt B):1235–1245   
159. Liu C, Bai Y, Xu X, et al. Exaggerated effects of particulate matter air pollution in genetic type II diabetes mellitus. Part Fibre Toxicol 2014;11:27   
160. Liu C, Fonken LK, Wang A, et al. Central IKKb inhibition prevents air pollution mediated peripheral inflammation and exaggeration of type II diabetes. Part Fibre Toxicol 2014;11:53   
161. Liu C, Ying Z, Harkema J, Sun Q, Rajagopalan S. Epidemiological and experimental links between air pollution and type 2 diabetes. Toxicol Pathol 2013;41:361–373   
162. Zanobetti A, Schwartz J. Are diabetics more susceptible to the health effects of airborne particles? Am J Respir Crit Care Med 2001; 164:831–833   
163. Zanobetti A, Schwartz J. Cardiovascular damage by airborne particles: are diabetics more susceptible? Epidemiology 2002;13:588– 592   
164. Zeka A, Zanobetti A, Schwartz J. Individuallevel modifiers of the effects of particulate matter on daily mortality. Am J Epidemiol 2006;163: 849–859   
165. Nemmar A, Subramaniyan D, Yasin J, Ali BH. Impact of experimental type 1 diabetes mellitus on systemic and coagulation vulnerability in mice acutely exposed to diesel exhaust particles. Part Fibre Toxicol 2013;10:14   
166. O’Neill MS, Veves A, Zanobetti A, et al. Diabetes enhances vulnerability to particulate air pollution-associated impairment in vascular reactivity and endothelial function. Circulation 2005;111:2913–2920   
167. O’Neill MS, Veves A, Sarnat JA, et al. Air pollution and inflammation in type 2 diabetes: a mechanism for susceptibility. Occup Environ Med 2007;64:373–379   
168. Moon KA, Guallar E, Umans JG, et al. Association between exposure to low to moderate arsenic levels and incident cardiovascular disease. A prospective cohort study. Ann Intern Med 2013;159:649–659   
169. Tellez-Plaza M, Guallar E, Howard BV, et al. Cadmium exposure and incident cardiovascular disease. Epidemiology 2013;24:421–429   
170. Lamas GA, Goertz C, Boineau R, et al.; TACT Investigators. Effect of disodium EDTA chelation regimen on cardiovascular events in patients with previous myocardial infarction: the TACT randomized trial. JAMA 2013;309:1241–1250 171. Been JV, Nurmatov UB, Cox B, Nawrot TS, van Schayck CP, Sheikh A. Effect of smoke-free 172. Peterson GCL, Hogrefe C, Corrigan AE, Neas LM, Mathur R, Rappold AG. Impact of reductions in emissions from major source sectors on fine particulate matter–related cardiovascular mortality. Environ Health Perspect 2020;128:17005 173. Ruiz-Hernandez A, Navas-Acien A, PastorBarriuso R, et al. Declining exposures to lead and cadmium contribute to explaining the reduction of cardiovascular mortality in the US population, 1988-2004. Int J Epidemiol 2017;46:1903–1912 174. Flanagan SV, Braman S, Puelle $\mathsf { R } ,$ et al. Leveraging health care communication channels for environmental health outreach in New Jersey. J Public Health Manag Pract 2020;26:E23–E26 175. Hadley MB, Vedanthan R, Fuster V. Air pollution and cardiovascular disease: a window of opportunity.Nat Rev Cardiol 2018;15:193–194 176. Wong KH, Durrani TS. Exposures to endocrine disrupting chemicals in consumer products-a guide for pediatricians. Curr Probl Pediatr Adolesc Health Care 2017;47:107–118   
177. Centers for Disease Contol and Prevention. General food environment resources, 2010. Accessed 10 July 2019. Available from https://www .cdc.gov/healthyplaces/healthtopics/healthyfood/ general.htm   
178. Swinburn B, Sacks G, Vandevijvere S, et al.; INFORMAS. INFORMAS (International Network for Food and Obesity/non-communicable diseases Research, Monitoring and Action Support): overview and key principles. Obes Rev 2013; 14(Suppl. 1):1–12   
179. Glanz K, Sallis JF, Saelens BE, Frank LD. Nutrition Environment Measures Survey in stores (NEMS-S): development and evaluation. Am J Prev Med 2007;32:282–289   
180. U.S. Department of Agriculture, Economic Research Service. Food environment atlas. Accessed 10 July 2019. Available from https://www .ers.usda.gov/data-products/food-environmentatlas/2019   
181. HerforthA,AhmedS.The foodenvironment, its effects on dietary consumption, and potential for measurement within agriculture-nutrition interventions. Food Secur 2015;7:505–520   
182. Lytle LA, Sokol RL. Measures of the food environment: a systematic review of the field, 2007-2015. Health Place 2017;44:18–34   
183. McKinnon RA, Reedy J, Morrissette MA, Lytle LA, Yaroch AL. Measures of the food environment: a compilation of the literature, 1990- 2007. Am J Prev Med 2009;36(Suppl.):S124–S133 184. Turner C, Aggarwal A, Walls H, et al. Concepts and critical perspectives for food environment research: a global framework with implications for action in low- and middle-income countries. Glob Food Secur 2018;18:93–101 185. Ahern M, Brown C, Dukas S. A national study of the association between food environments and county-level health outcomes. J Rural Health 2011;27:367–379   
186. Haynes-Maslow L, Leone LA. Examining the relationship between the food environment and adult diabetes prevalence by county economic and racial composition: an ecological study. BMC Public Health 2017;17:648   
187. Auchincloss AH, Diez Roux AV, Mujahid MS, Shen M, Bertoni AG, Carnethon MR. Neighborhood resources for physical activity and healthy

legislation on perinatal and child health: a systematic review and meta-analysis. Lancet 2014; 383:1549–1560

foods and incidence of type 2 diabetes mellitus: the Multi-Ethnic Study of Atherosclerosis. Arch Intern Med 2009;169:1698–1704

188. den Braver NR, Lakerveld J, Rutters F, Schoonmade LJ, Brug J, Beulens JWJ. Built environmental characteristics and diabetes: a systematic review and meta-analysis. BMC Med 2018;16:12   
189. Gebreab SY, Hickson DA, Sims M, et al. Neighborhood social and physical environments and type 2 diabetes mellitus in African Americans: the Jackson Heart Study. Health Place 2017; 43:128–137   
190. Herrick CJ, Yount BW, Eyler AA. Implications of supermarket access, neighbourhood walkability and poverty rates for diabetes risk in an employee population. Public Health Nutr 2016; 19:2040–2048   
191. Christine PJ, Auchincloss AH, Bertoni AG, et al. Longitudinal associations between neighborhood physical and social environments and incident type 2 diabetes mellitus: the MultiEthnic Study of Atherosclerosis (MESA). JAMA Intern Med 2015;175:1311–1320   
192. Meyer KA, Boone-Heinonen J, Duffey KJ, et al. Combined measure of neighborhood food and physical activity environments and weightrelated outcomes: the CARDIA study. Health Place 2015;33:9–18   
193. Tabaei BP, Rundle AG, Wu WY, et al. Associations of residential socioeconomic, food, and built environments with glycemic control in persons with diabetes in New York City from 2007– 2013. Am J Epidemiol 2018;187:736–745 194. Kern DM, Auchincloss AH, Stehr MF, et al. Neighborhood price of healthier food relative to unhealthy food and its association with type 2 diabetes and insulin resistance: the Multi-Ethnic Study of Atherosclerosis. Prev Med 2018;106: 122–129   
195. Coleman-Jensen A, Gregory C, Singh A. Household food security in the United States in 2013 (Economic Research Report No. 173). U.S. Department of Agriculture, Economic Research Service, 2014. Accessed 25 October 2020. Available from https://www.ers.usda.gov/webdocs/ publications/45265/48787_err173.pdf?v $= 0$ 196. Seligman HK, Lyles C, Marshall MB, et al. A pilot food bank intervention featuring diabetesappropriate food improved glycemic control among clients in three states. Health Aff (Millwood) 2015;34:1956–1963   
197. Berkowitz SA, Seligman HK, Choudhry NK. Treat or eat: food insecurity, cost-related medication underuse, and unmet needs. Am J Med 2014;127:303–310.e3   
198. Walker RJ, Gebregziabher M, Martin-Harris B, Egede LE. Quantifying direct effects of social determinants of health on glycemic control in adults with type 2 diabetes. Diabetes Technol Ther 2015;17:80–87   
199. Walker RJ, Williams JS, Egede LE. Pathways between food insecurity and glycaemic control in individuals with type 2 diabetes. Public Health Nutr 2018;21:3237–3244   
200. Seligman HK, Schillinger D. Hunger and socioeconomic disparities in chronic disease. N Engl J Med 2010;363:6–9   
201. Orr CJ, Keyserling TC, Ammerman AS, Berkowitz SA. Diet quality trends among adults with diabetes by socioeconomic status in the U.S.: 1999-2014. BMC Endocr Disord 2019;19:54

202. Drewnowski A, Eichelsdoerfer P. Can lowincome Americans afford a healthy diet? Nutr Today 2010;44:246–249

203. Darmon N, Drewnowski A. Contribution of food prices and diet cost to socioeconomic disparities in diet quality and health: a systematic review and analysis. Nutr Rev 2015;73:643–660 204. Bomberg EM, Neuhaus J, Hake MM, Engelhard EM, Seligman HK. Food preferences and coping strategies among diabetic and nondiabetic households served by US food pantries. J Hunger Environ Nutr 2019;14:4–17   
205. Billimek J, Sorkin DH. Food insecurity, processes of care, and self-reported medication underuse in patients with type 2 diabetes: results from the California Health Interview Survey. Health Serv Res 2012;47:2159–2168   
206. Herman D, Afulani P, Coleman-Jensen A, Harrison GG. Food insecurity and cost-related medication underuse among nonelderly adults in a nationally representative sample. Am J Public Health 2015;105:e48–e59   
207. Silverman J, Krieger J, Kiefer M, Hebert P, Robinson J, Nelson K. The relationship between food insecurity and depression, diabetes distress and medication adherence among low-income patients with poorly-controlled diabetes. J Gen Intern Med 2015;30:1476–1480   
208. Leung CW, Epel ES, Willett WC, Rimm EB, Laraia BA. Household food insecurity is positively associated with depression among low-income supplemental nutrition assistance program participants and income-eligible nonparticipants. J Nutr 2015;145:622–627   
209. Arenas DJ, Thomas A, Wang J, DeLisser HM. A systematic review and meta-analysis of depression, anxiety, and sleep disorders in US adults with food insecurity. J Gen Intern Med 2019;34:2874–2882   
210. Kinsey EW, Dupuis R, Oberle M, Cannuscio CC, Hillier A. Chronic disease self-management within the monthly benefit cycle of the Supplemental Nutrition Assistance Program. Public Health Nutr 2019;22:2248–2259   
211. Seligman HK, Bindman AB, Vittinghoff E, Kanaya AM, Kushel MB. Food insecurity is associated with diabetes mellitus: results from the National Health Examination and Nutrition Examination Survey (NHANES) 1999-2002. J Gen Intern Med 2007;22:1018–1023   
212. Berkowitz SA, Karter AJ, Corbie-Smith G, et al. Food insecurity, food “deserts,” and glycemic control in patients with diabetes: a longitudinal analysis. Diabetes Care 2018;41:1188–1195 213. Barnard LS, Wexler DJ, DeWalt D, Berkowitz SA. Material need support interventions for diabetes prevention and control: a systematic review. Curr Diab Rep 2015;15:574   
214. Seligman HK, Bolger AF, Guzman D, Lopez ´ A, Bibbins-Domingo K. Exhaustion of food budgets at month’s end and hospital admissions for hypoglycemia. Health Aff (Millwood) 2014;33: 116–123   
215. Seligman HK, Davis TC, Schillinger D, Wolf MS. Food insecurity is associated with hypoglycemia and poor diabetes self-management in a low-income sample with diabetes. J Health Care Poor Underserved 2010;21:1227–1233   
216. Seligman HK, Jacobs EA, Lopez A, Tschann J, ´ Fernandez A. Food insecurity and glycemic control among low-income patients with type 2 diabetes. Diabetes Care 2012;35:233–238 218. Berkowitz SA, Karter AJ, Lyles CR, et al. Low socioeconomic status is associated with increased risk for hypoglycemia in diabetes patients: the Diabetes Study of Northern California (DISTANCE). J Health Care Poor Underserved 2014;25:478–490   
219. Heerman WJ, Wallston KA, Osborn CY, et al. Food insecurity is associated with diabetes selfcare behaviours and glycaemic control. Diabet Med 2016;33:844–850   
220. Seligman HK, Smith M, Rosenmoss S, Marshall MB, Waxman E. Comprehensive diabetes self-management support from food banks: a randomized controlled trial. Am J Public Health 2018;108:1227–1234   
221. Palar K, Napoles T, Hufstedler LL, et al. Comprehensive and medically appropriate food support is associated with improved HIV and diabetes health. J Urban Health 2017;94:87–99 222. Richardson AS, Ghosh-Dastidar M, Beckman R, et al. Can the introduction of a full-service supermarket in a food desert improve residents’ economic status and health? Ann Epidemiol 2017; 27:771–776   
223. Zhang YT, Mujahid MS, Laraia BA, et al. Association between neighborhood supermarket presence and glycated hemoglobin levels among patients with type 2 diabetes mellitus. Am J Epidemiol 2017;185:1297–1303   
224. Gary-Webb TL, Egnot NS, Nugroho A, Dubowitz T, Troxel WM. Changes in perceptions of neighborhood environment and cardiometabolic outcomes in two predominantly African American neighborhoods. BMC Public Health 2020;20:52   
225. Dubowitz T, Ghosh-Dastidar M, Cohen DA, et al. Diet and perceptions change with supermarket introduction in a food desert, but not because of supermarket use. Health Aff (Millwood) 2015;34:1858–1868   
226. Baird MD, Schwartz HL, Hunter GP, et al. Does large-scale neighborhood reinvestment work? Effects of public–private real estate investment on local sales prices, rental prices, and crime rates. Hous Policy Debate 2020;30:164– 190   
227. Kazemian P, Shebl FM, McCann N, Walensky RP, Wexler DJ. Evaluation of the cascade of diabetes care in the United States, 2005- 2016. JAMA Intern Med 2019;179:1376–1385 228. Danaei G, Friedman AB, Oza S, Murray CJL, Ezzati M. Diabetes prevalence and diagnosis in US states: analysis of health surveys. Popul Health Metr 2009;7:16   
229. American Diabetes Association. Economic costs of diabetes in the U.S. in 2017. Diabetes Care 2018;41:917–928   
230. Liese AD, Ma $\mathsf { X } ,$ Reid L, et al. Health care access and glycemic control in youth and young adults with type 1 and type 2 diabetes in South Carolina. Pediatr Diabetes 2019;20:321–329 231. Ngo-Metzger $\scriptstyle { \mathsf { Q } } ,$ Sorkin DH, Billimek J, Greenfield S, Kaplan SH. The effects of financial pressures on adherence and glucose control among racial/ethnically diverse patients with diabetes. J Gen Intern Med 2012;27:432–437 232. Lu H, Holt JB, Cheng YJ, Zhang X, Onufrak S, Croft JB. Population-based geographic access to

217. Berkowitz SA, Baggett TP, Wexler DJ, Huskey KW, Wee CC. Food insecurity and metabolic control among U.S. adults with diabetes. Diabetes Care 2013;36:3093–3099

233. Lopez-DeFede A, Stewart JE. Diagnosed \` diabetes prevalence and risk factor rankings, by state, 2014–2016: a ring map visualization. Prev Chronic Dis 2019;16:E44   
234. Rutledge SA, Masalovich S, Blacher RJ, Saunders MM. Diabetes self-management education programs in nonmetropolitan countiesd United States, 2016. MMWR Surveill Summ 2017;66:1–6   
235. DeVoe JE, Tillotson CJ, Wallace LS. Usual source of care as a health insurance substitute for U.S. adults with diabetes? Diabetes Care 2009; 32:983–989   
236. Kang H, Lobo JM, Kim S, Sohn M-W. Costrelated medication non-adherence among U.S. adults with diabetes. Diabetes Res Clin Pract 2018;143:24–33   
237. Lessem SE, Pendley RP. QuickStats: percentage of adults aged ${ \ge } 4 5$ years who reduced or delayed medication to save money in the past 12 months among those who were prescribed medication, by diagnosed diabetes status and agedNational Health Interview Survey, 2015. MMWR Morb Mortal Wkly Rep 2017;66:679   
238. Patel MR, Piette JD, Resnicow K, KowalskiDobson T, Heisler M. Social determinants of health, cost-related non-adherence, and costreducing behaviors among adults with diabetes: findings from the National Health Interview Survey. Med Care 2016;54:796–803   
239. Herkert D, Vijayakumar P, Luo J, et al. Costrelated insulin underuse among patients with diabetes. JAMA Intern Med 2019;179:112–114 240. Piette JD, Wagner TH, Potter MB, Schillinger D. Health insurance status, cost-related medication underuse, and outcomes among diabetes patients in three systems of care. Med Care 2004; 42:102–109   
241. Rosenthal E. When high prices mean needless death. JAMA Intern Med 2019;179:114–115 242. Doucette ED, Salas J, Wang J, Scherrer JF. Insurance coverage and diabetes quality indicators among patients with diabetes in the US general population. Prim Care Diabetes 2017; 11:515–521   
243. Ali MK, Shah MK. Age and age-old disparities in diabetes care persist. JAMA Intern Med 2019;179:1386–1387   
244. Brown AF, Gregg EW, Stevens MR, et al. Race, ethnicity, socioeconomic position, and quality of care for adults with diabetes enrolled in managed care: the Translating Research Into Action for Diabetes (TRIAD) study. Diabetes Care 2005;28:2864–2870   
245. Sequist TD, Adams A, Zhang F, Ross-Degnan D, Ayanian JZ. Effect of quality improvement on racial disparities in diabetes care. Arch Intern Med 2006;166:675–681   
246. Heisler M, Smith DM, Hayward RA, Krein ${ \mathsf { S L } } ,$ Kerr EA. Racial disparities in diabetes care processes, outcomes, and treatment intensity. Med Care 2003;41:1221–1232   
247. Hunt CW, Grant JS, Appel SJ. An integrative review of community health advisors in type 2 diabetes. J Community Health 2011;36:883–893 248. Little TV, Wang ML, Castro EM, Jimenez J, ´ Rosal MC. Community health worker interventions for Latinos with type 2 diabetes: a systematic

endocrinologists in the United States, 2012. BMC Health Serv Res 2015;15:541

review of randomized controlled trials. Curr Diab Rep 2014;14:558

250. Shah M, Kaselitz E, Heisler M. The role of community health workers in diabetes: update on current literature. Curr Diab Rep 2013;13: 163–171   
251. Islam N, Nadkarni SK, Zahn D, Skillman M, Kwon SC, Trinh-Shevrin C. Integrating community health workers within Patient Protection and Affordable Care Act implementation. J Public Health Manag Pract 2015;21:42–50   
252. Centers for Disease Control and Prevention. Addressing Chronic Disease Through Community Health Workers: A Policy and Systems-Level Approach; Second Edition. Atlanta, GA, National Center for Chronic Disease Prevention and Health Promotion, Division for Heart Disease and Stroke Prevention, April 2015. Accessed 25 October 2020. Available from https://www.cdc.gov/dhdsp/docs/ chw_brief.pdf   
253. National Association of Chronic Disease Directors. Community programs linked to clinical services – community health workers: reimbursement/advocacy. Accessed 10 June 2020. Available from https://www.chronicdisease.org/ mpage/domain4_chw_ra   
254. Egbujie BA, Delobelle PA, Levitt N, Puoane T, Sanders D, van Wyk B. Role of community health workers in type 2 diabetes mellitus selfmanagement: a scoping review. PLoS One 2018; 13:e0198424   
255. Palmas W, March D, Darakjy S, et al. Community health worker interventions to improve glycemic control in people with diabetes: a systematic review and meta-analysis. J Gen Intern Med 2015;30:1004–1012   
256. Gary TL, Batts-Turner M, Yeh HC, et al. The effects of a nurse case manager and a community health worker team on diabetic control, emergency department visits, and hospitalizations among urban African Americans with type 2 diabetes mellitus: a randomized controlled trial. Arch Intern Med 2009;169:1788–1794   
257. Kangovi S, Mitra N, Grande D, Huo H, Smith RA, Long JA. Community health worker support for disadvantaged patients with multiple chronic diseases: a randomized clinical trial. Am J Public Health 2017;107:1660–1667   
258. Kangovi S, Mitra N, Norton L, et al. Effect of community health worker support on clinical outcomes of low-income patients across primary care facilities: a randomized clinical trial. JAMA Intern Med 2018;178:1635–1643   
259. Peek ME, Cargill A, Huang ES. Diabetes health disparities: a systematic review of health care interventions. Med Care Res Rev 2007; 64(Suppl.):101S–156S   
260. Ricci-Cabello I, Ruiz-Perez I, Nevot-Cordero ´ A, Rodr´ıguez-Barranco M, Sordo L, Gonçalves DC. Health care interventions to improve the quality of diabetes care in African Americans: a systematic review and meta-analysis. Diabetes Care 2013;36:760–768   
261. Porterfield D, Jacobs S, Farrell K, et al. Evaluation of the Medicaid Coverage for the National Diabetes Prevention Program Demonstration Project: Final Report. RTI International, November 2018. Accessed 25 October 2020.

249. Norris SL, Chowdhury FM, Van Le K, et al. Effectiveness of community health workers in the care of persons with diabetes. Diabet Med 2006;23:544–556

Available from https://cdn.ymaws.com/www .chronicdisease.org/resource/resmgr/diabetes_ dpp_materials/medicaid_demonstration_proje .pdf   
262. Hill-Briggs F, Lazo M, Renosky R, Ewing C. Usability of a diabetes and cardiovascular disease education module in an African American, diabetic sample with physical, visual, and cognitive impairment. Rehabil Psychol 2008;53:1–8   
263. Lilly CL, Bryant LL, Leary JM, et al.; MSHA. Evaluation of the effectiveness of a problemsolving intervention addressing barriers to cardiovascular disease prevention behaviors in 3 underserved populations: Colorado, North Carolina, West Virginia, 2009. Prev Chronic Dis 2014;11:E32   
264. Boulware LE, Ephraim PL, Hill-Briggs F, et al. Hypertension self-management in socially disadvantaged African Americans: the Achieving Blood Pressure Control Together (ACT) randomized comparative effectiveness trial. J Gen Intern Med 2020;35:142–152   
265. Brown DS, Delavar A. The Affordable Care Act and insurance coverage for persons with diabetes in the United States. J Hosp Manag Health Policy 2018;2:2   
266. Casagrande SS, McEwen LN, Herman WH. Changes in health insurance coverage under the Affordable Care Act: a national sample of U.S. adults with diabetes, 2009 and 2016. Diabetes Care 2018;41:956–962   
267. Lee J, Callaghan T, Ory M, Zhao H, Bolin JN. The impact of Medicaid expansion on diabetes management. Diabetes Care 2020;43:1094–1101 268. Kaufman HW, Chen Z, Fonseca VA, McPhaul MJ. Surge in newly identified diabetes among medicaid patients in 2014 within Medicaid expansion states under the Affordable Care Act. Diabetes Care 2015;38:833–837   
269. Zhang JX, Bhaumik D, Huang ES, Meltzer DO. Change in insurance status and cost-related medication non-adherence among older U.S. adults with diabetes from 2010 to 2014. J Health Med Econ 2018;4:7   
270. Tunstall H, Mitchell R, Gibbs J, Platt S, Dorling D. Is economic adversity always a killer? Disadvantaged areas with relatively low mortality rates. J Epidemiol Community Health 2007;61:337–343 271. Kawachi I, Berkman L. Social cohesion, social capital,and health.InSocialEpidemiology. Berkman LF, Kawachi I, Eds. New York, Oxford University Press, 2000, p. 174   
272. Whitehead M, Diderichsen F. Social capital and health: tip-toeing through the minefield of evidence. Lancet 2001;358:165–166   
273. Hawe P, Shiell A. Social capital and health promotion: a review. Soc Sci Med 2000;51:871–885 274. Szreter S, Woolcock M. Health by association? Social capital, social theory, and the political economy of public health. Int J Epidemiol 2004;33:650–667   
275. Gittell R, Vidal A. Community Organizing: Building Social Capital as a Development Strategy. Thousand Oaks, CA, Sage Publications, Inc., 1998 276. Portes A. Social capital: its origins and applications in modern sociology. Annu Rev Sociol 1998;24:1–24   
277. van Staveren IP, Pervaiz Z, Chaudhary AR. Diversity, inclusiveness and social cohesion. ISS Working Paper Series/General Series. 2013. Accessed 25 October 2020. Available from http:// hdl.handle.net/1765/50480 278. World Health Organization. Social determinants of health: evidence on social determinants of health. Accessed 25 October 2020. Available from https://www.who.int/social_ determinants/themes/en/   
279. Berger-Schmitt R. Considering social cohesion in quality of life assessments: concept and measurement. Soc Indic Res 2002;58:403–428 280. Berger-Schmitt R, Noll HH. Conceptual framework and structure of a European system of social indicator. In EuroReporting Working Paper #9. Mannheim, Centre for Survey Research and Methodology, 2000   
281. Chuang Y-C, Chuang K-Y, Yang T-H. Social cohesion matters in health. Int J Equity Health 2013;12:87   
282. van Dam HA, van der Horst FG, Knoops L, Ryckman RM, Crebolder HF, van den Borne BH. Social support in diabetes: a systematic review of controlled intervention studies. Patient Educ Couns 2005;59:1–12   
283. Taylor SE. Social support: a review. In The Handbook of Health Psychology. Friedman MS, Ed. New York, Oxford University Press, 2011, pp. 189–214   
284. Strom JL, Egede LE. The impact of social support on outcomes in adult patients with type 2 diabetes: a systematic review. Curr Diab Rep 2012;12:769–781   
285. Ford ME, Tilley BC, McDonald PE. Social support among African-American adults with diabetes, part 2: a review. J Natl Med Assoc 1998;90:425–432   
286. Thoits PA. Social support an psychological well-being: theoretical possibilities. In Social Support: Theory, Research, and Application. Sarason IG, Sarason BR, Eds. Hingram, MA, Kluwer, 1985, pp. 53–72   
287. Flor CR, Baldoni NR, Aquino JA, et al. What is ˆ the association between social capital and diabetes mellitus? A systematic review. Diabetes Metab Syndr 2018;12:601–605   
288. Farajzadegan Z, Jafari N, Nazer S, Keyvanara M, Zamani A. Social capitalda neglected issue in diabetes control: a cross-sectional survey in Iran. Health Soc Care Community 2013;21:98–103 289. Long JA, Field S, Armstrong K, Chang VW, Metlay JP. Social capital and glucose control. J Community Health 2010;35:519–526   
290. Mendoza-Nu´nez VM, Flores-Bello C, Correa- \~ Munoz E, Retana-U Galde R, Ruiz-Ramos M. Re- \~ lationship between social support networks and diabetes control and its impact on the quality of life in older community-dwelling Mexicans. Nutr Hosp 2016;33:1312–1316   
291. Ciechanowski P, Russo J, Katon WJ, et al. Relationship styles and mortality in patients with diabetes. Diabetes Care 2010;33:539–544   
292. Trief P, Sandberg JG, Ploutz-Snyder R, et al. Promoting couples collaboration in type 2 diabetes: the diabetes support project pilot data. Fam Syst Health 2011;29:253–261   
293. Roblin DW. The potential of cellular technology to mediate social networks for support of chronic disease self-management. J Health Commun 2011;16(Suppl. 1):59–76   
294. Tang TS, Brown MB, Funnell MM, Anderson RM. Social support, quality of life, and selfcare behaviors among African Americans with type 2 diabetes. Diabetes Educ 2008;34:266– 276 296. Williams DR, Lawrence JA, Davis BA. Racism and health: evidence and needed research. Annu Rev Public Health 2019;40:105–125   
297. Reskin B. The race discrimination system. Annu Rev Sociol 2012;38:17–35   
298. Whitaker KM, Everson-Rose SA, Pankow JS, et al. Experiences of discrimination and incident type 2 diabetes mellitus: the Multi-Ethnic Study of Atherosclerosis (MESA). Am J Epidemiol 2017; 186:445–455   
299. Bacon $\mathbb { K } ,$ Stuver SO, Cozier YC, Palmer JR, Rosenberg L, Ruiz-Narvaez EA. Perceived racism´ and incident diabetes in the Black Women’s Health Study. Diabetologia 2017;60:2221–2225   
300. Sarkar U, Piette JD, Gonzales R, et al. Preferences for self-management support: findings from a survey of diabetes patients in safety-net health systems. Patient Educ Couns 2008;70:102–110 301. National Academies of Sciences, Engineering, and Medicine. A Framework for Educating Health Professionals to Address the Social Determinants of Health. Washington, DC, The National Academies Press, 2016   
302. Alley DE, Asomugha CN, Conway PH, Sanghavi DM. Accountable health communitiesdaddressing social needs through Medicare and Medicaid. N Engl J Med 2016;374:8–11   
303. Gottlieb LM, Tirozzi KJ, Manchanda R, Burns AR, Sandel MT. Moving electronic medical records upstream: incorporating social determinants of health. Am J Prev Med 2015;48:215–218   
304. Adler NE, Stead WW. Patients in contextd EHR capture of social and behavioral determinants of health. N Engl J Med 2015;372:698–701 305. Giuse NB, Koonce TY, Kusnoor SV, et al. Institute of Medicine measures of social and behavioral determinants of health: a feasibility study. Am J Prev Med 2017;52:199–206   
306. Dixon B, Pena M-M, Taveras EM. Lifecourse \~ approach to racial/ethnic disparities in childhood obesity. Adv Nutr 2012;3:73–82   
307. Gostin LO, Hodge JG Jr, Levin DE. Legal interventions to address us reductions in life expectancy. JAMA 2020;324:1037–1038   
308. Thomas SB, Quinn SC, Butler J, Fryer CS, Garza MA. Toward a fourth generation of disparities research to achieve health equity. Annu Rev Public Health 2011;32:399–416   
309. Angulo AJ (Ed.). Miseducation: A History of Ignorance-Making in America and Abroad. Baltimore, MD, Johns Hopkins University Press, 2016 310. Douglass F. Chapter X, Learning to Read. In Life and Times of Frederick Douglass. New York, Citadel Press, 1983   
311. Bell D. Silent Covenants: Brown v. Board of Education and the Unfulfilled Hopes for Racial Reform. New York, Oxford University Press, 2004 312. Rothstein E. The Color of Law: A Forgotten History of How Our Government Segregated America. New York, W.W. Norton and Co. Inc., 2017 313. Federal Housing Authority. Underwriting Manual. Underwriting and Valuation Procedure Under Title II of the National Housing Act. Washington, DC, Federal Housing Administration, 1936 314. Eisenhauer E. In poor health: supermarket redlining and urban nutrition. GeoJournal 2001; 53:125–133

295. Zhang X,NorrisSL,GreggEW, BecklesG.Social support and mortality among older persons with diabetes. Diabetes Educ 2007;33:273–281